"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGuessRuleIdsForBulkAction = useGuessRuleIdsForBulkAction;
var _react = require("react");
var _rule_management = require("../../../../../common/api/detection_engine/rule_management");
var _rules_table_context = require("../../../rule_management_ui/components/rules_table/rules_table/rules_table_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGuessRuleIdsForBulkAction() {
  const rulesTableContext = (0, _rules_table_context.useRulesTableContextOptional)();
  return (0, _react.useCallback)(bulkActionType => {
    const allRules = rulesTableContext !== null && rulesTableContext !== void 0 && rulesTableContext.state.isAllSelected ? rulesTableContext.state.rules : [];
    const processingRules = bulkActionType === _rule_management.BulkActionTypeEnum.enable ? allRules.filter(x => !x.enabled) : bulkActionType === _rule_management.BulkActionTypeEnum.disable ? allRules.filter(x => x.enabled) : allRules;
    return processingRules.map(r => r.id);
  }, [rulesTableContext]);
}