"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULE_IS_READY_FOR_UPGRADE_DESCRIPTION = exports.RULE_HAS_SOFT_CONFLICTS_EDIT_FINAL_VERSION = exports.RULE_HAS_SOFT_CONFLICTS_DESCRIPTION = exports.RULE_HAS_SOFT_CONFLICTS_ACCEPT_SUGGESTED_UPDATE = exports.RULE_HAS_HARD_CONFLICTS_KEEP_YOUR_CHANGES = exports.RULE_HAS_HARD_CONFLICTS_EDIT_FINAL_VERSION = exports.RULE_HAS_HARD_CONFLICTS_DESCRIPTION = exports.RULE_HAS_HARD_CONFLICTS_ACCEPT_ELASTIC_UPDATE = exports.RULE_HAS_CONFLICTS = exports.RULE_BASE_VERSION_IS_MISSING_DESCRIPTION = exports.NUM_OF_CONFLICTS = exports.FIELD_MODIFIED_BADGE_DESCRIPTION = void 0;
exports.RuleUpgradeHelper = RuleUpgradeHelper;
exports.VERSION_UPDATE_INFO = exports.UPGRADE_STATUS = exports.TOTAL_NUM_OF_FIELDS = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_react = require("../../../../../../common/lib/kibana/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/rule_upgrade/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TOTAL_NUM_OF_FIELDS = count => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.rules.upgradeRules.diffTab.totalNumOfFieldsWithUpdates",
  defaultMessage: "{countValue} {count, plural, one {field} other {fields}} {count, plural, one {requires} other {require}} review",
  values: {
    countValue: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 18,
        columnNumber: 27
      }
    }, count),
    count
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 15,
    columnNumber: 3
  }
});
exports.TOTAL_NUM_OF_FIELDS = TOTAL_NUM_OF_FIELDS;
const VERSION_UPDATE_INFO = (numOfFieldsWithUpdates, currentVersionNumber, targetVersionNumber) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.rules.upgradeRules.diffTab.versionUpdateInfo",
  defaultMessage: "{numOfFieldsWithUpdatesValue} {numOfFieldsWithUpdates, plural, one {field} other {fields}} being changed in this Elastic update from version {currentVersionNumber} to {targetVersionNumber}",
  values: {
    numOfFieldsWithUpdatesValue: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 36
      }
    }, numOfFieldsWithUpdates),
    numOfFieldsWithUpdates,
    currentVersionNumber,
    targetVersionNumber
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 3
  }
});
exports.VERSION_UPDATE_INFO = VERSION_UPDATE_INFO;
const NUM_OF_CONFLICTS = count => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.rules.upgradeRules.diffTab.numOfConflicts",
  defaultMessage: "{countValue} {count, plural, one {conflict} other {conflicts}}",
  values: {
    countValue: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 27
      }
    }, count),
    count
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 3
  }
});
exports.NUM_OF_CONFLICTS = NUM_OF_CONFLICTS;
const UPGRADE_RULES_DOCS_LINK = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.updateYourRulesDocsLink', {
  defaultMessage: 'update your rules'
});
function RuleUpgradeHelper() {
  const {
    docLinks: {
      links: {
        securitySolution: {
          updatePrebuiltDetectionRules
        }
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.upgradeRules.ruleUpgradeHelper",
    defaultMessage: "Understand how to\xA0{docsLink}.",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: updatePrebuiltDetectionRules,
        target: "_blank",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 11
        }
      }, UPGRADE_RULES_DOCS_LINK)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  });
}
const UPGRADE_STATUS = exports.UPGRADE_STATUS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.upgradeStatusTitle', {
  defaultMessage: 'Status:'
});
const RULE_HAS_CONFLICTS = count => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.ruleHasConflicts', {
  values: {
    count
  },
  defaultMessage: '{count} {count, plural, one {field has a conflict} other {fields have conflicts}}. Review and provide a final update.'
});
exports.RULE_HAS_CONFLICTS = RULE_HAS_CONFLICTS;
const RULE_HAS_SOFT_CONFLICTS_DESCRIPTION = exports.RULE_HAS_SOFT_CONFLICTS_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.ruleHasSoftConflictsDescription', {
  defaultMessage: 'We auto-resolved the conflicts between your changes and the Elastic update. Review them and do one of the following:'
});
const RULE_HAS_SOFT_CONFLICTS_ACCEPT_SUGGESTED_UPDATE = exports.RULE_HAS_SOFT_CONFLICTS_ACCEPT_SUGGESTED_UPDATE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.ruleHasSoftConflictsAcceptSuggestedUpdate', {
  defaultMessage: 'Accept the suggested update.'
});
const RULE_HAS_SOFT_CONFLICTS_EDIT_FINAL_VERSION = exports.RULE_HAS_SOFT_CONFLICTS_EDIT_FINAL_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.ruleHasSoftConflictsEditFinalVersion', {
  defaultMessage: 'Edit the final version and choose a more appropriate field value.'
});
const RULE_HAS_HARD_CONFLICTS_DESCRIPTION = exports.RULE_HAS_HARD_CONFLICTS_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.ruleHasHardConflictsDescription', {
  defaultMessage: "We couldn't auto-resolve the conflicts between your changes and the Elastic update. To resolve them, do one of the following:"
});
const RULE_HAS_HARD_CONFLICTS_KEEP_YOUR_CHANGES = exports.RULE_HAS_HARD_CONFLICTS_KEEP_YOUR_CHANGES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.ruleHasHardConflictsKeepYourChanges', {
  defaultMessage: 'Keep your changes and reject the Elastic update.'
});
const RULE_HAS_HARD_CONFLICTS_ACCEPT_ELASTIC_UPDATE = exports.RULE_HAS_HARD_CONFLICTS_ACCEPT_ELASTIC_UPDATE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.ruleHasHardConflictsAcceptElasticUpdate', {
  defaultMessage: 'Accept the Elastic update and overwrite your changes.'
});
const RULE_HAS_HARD_CONFLICTS_EDIT_FINAL_VERSION = exports.RULE_HAS_HARD_CONFLICTS_EDIT_FINAL_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.ruleHasHardConflictsEditFinalVersion', {
  defaultMessage: 'Edit the final version by combining your changes with the Elastic update or choosing a more appropriate field value.'
});
const RULE_IS_READY_FOR_UPGRADE_DESCRIPTION = exports.RULE_IS_READY_FOR_UPGRADE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.ruleIsReadyForUpgradeDescription', {
  defaultMessage: 'There are no conflicts. The rule is ready to be updated.'
});
const FIELD_MODIFIED_BADGE_DESCRIPTION = exports.FIELD_MODIFIED_BADGE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeFlyout.fieldModifiedBadgeDescription', {
  defaultMessage: 'This field value differs from the one provided in the original version of the rule.'
});
const RULE_BASE_VERSION_IS_MISSING_DESCRIPTION = exports.RULE_BASE_VERSION_IS_MISSING_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeFlyout.baseVersionMissingDescription', {
  defaultMessage: "The original, unedited version of this Elastic rule couldn't be found. This sometimes happens when a rule hasn't been updated in a while. You can still update this rule, but will only have access to its current version and the incoming Elastic update. Updating Elastic rules more often can help you avoid this in the future. We encourage you to review this update carefully and ensure your changes are not accidentally overwritten."
});