"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.constructThreatMappingDescription = exports.TimelineTitle = exports.Threshold = exports.ThreatMapping = exports.ThreatIndex = exports.SuppressAlertsDuration = exports.SuppressAlertsByField = exports.SavedQueryName = exports.RuleType = exports.RuleDefinitionSection = exports.RequiredFields = exports.Query = exports.NewTermsFields = exports.MissingFieldsStrategy = exports.MachineLearningJobList = exports.Index = exports.HistoryWindowSize = exports.Filters = exports.DataViewIndexPattern = exports.DataViewId = exports.AnomalyThreshold = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/unified-search-plugin/public");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _rule_schema = require("../../../../../common/api/detection_engine/model/rule_schema");
var _utility_types = require("../../../../../common/utility_types");
var descriptionStepI18n = _interopRequireWildcard(require("../../../rule_creation_ui/components/description_step/translations"));
var _integrations_description = require("../../../common/components/related_integrations/integrations_description");
var _alert_suppression_label = require("../../../rule_creation_ui/components/description_step/alert_suppression_label");
var _use_get_saved_query = require("../../../common/use_get_saved_query");
var threatMatchI18n = _interopRequireWildcard(require("../../../../common/components/threat_match/translations"));
var timelinesI18n = _interopRequireWildcard(require("../../../../timelines/components/timeline/translations"));
var _ml_jobs_description = require("../../../rule_creation/components/ml_jobs_description/ml_jobs_description");
var _ml_job_link = require("../../../rule_creation/components/ml_job_link/ml_job_link");
var _use_security_jobs = require("../../../../common/components/ml_popover/hooks/use_security_jobs");
var _kibana_react = require("../../../../common/lib/kibana/kibana_react");
var _badge_list = require("./badge_list");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_alert_suppression = require("../../logic/use_alert_suppression");
var _required_field_icon = require("./required_field_icon");
var _rule_definition_section = require("./rule_definition_section.styles");
var _helpers = require("./helpers");
var _use_default_index_pattern = require("../../hooks/use_default_index_pattern");
var _date_math = require("../../../../common/utils/date_math");
var _constants2 = require("../../../../common/constants");
var _translations5 = require("../../../rule_creation/components/eql_query_edit/translations");
var _use_data_view = require("./three_way_diff/final_edit/fields/hooks/use_data_view");
var _match_filters_to_index_pattern = require("../../../../common/components/query_bar/match_filters_to_index_pattern");
var _rule_field_name = require("./rule_field_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/rule_definition_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SavedQueryName = ({
  savedQueryName
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "savedQueryNamePropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 3
  }
}, savedQueryName);
exports.SavedQueryName = SavedQueryName;
const Filters = ({
  filters,
  dataViewId,
  index,
  'data-test-subj': dataTestSubj
}) => {
  const defaultIndexPattern = (0, _use_default_index_pattern.useDefaultIndexPattern)();
  const useDataViewParams = dataViewId ? {
    dataViewId
  } : {
    indexPatterns: index !== null && index !== void 0 ? index : defaultIndexPattern
  };
  const {
    dataView
  } = (0, _use_data_view.useDataView)(useDataViewParams);
  const isEsql = filters.some(filter => {
    var _filter$query;
    return (filter === null || filter === void 0 ? void 0 : (_filter$query = filter.query) === null || _filter$query === void 0 ? void 0 : _filter$query.language) === 'esql';
  });
  if (!(dataView !== null && dataView !== void 0 && dataView.id) || isEsql) {
    return null;
  }
  const flattenedFilters = (0, _public.mapAndFlattenFilters)(filters);
  const matchedFilters = (0, _match_filters_to_index_pattern.matchFiltersToIndexPattern)(dataView.id, flattenedFilters);
  const styles = _rule_definition_section.filtersStyles;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": dataTestSubj,
    className: styles.flexGroup,
    wrap: true,
    responsive: false,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.FilterItems, {
    filters: matchedFilters,
    indexPatterns: [dataView],
    readOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }));
};
exports.Filters = Filters;
const Query = ({
  query,
  'data-test-subj': dataTestSubj = 'query'
}) => {
  const styles = _rule_definition_section.queryStyles;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    className: styles.content,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 5
    }
  }, query);
};
exports.Query = Query;
const Index = ({
  index
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: index,
  "data-test-subj": "indexPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 143,
    columnNumber: 3
  }
});
exports.Index = Index;
const DataViewId = ({
  dataViewId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "dataViewIdPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 151,
    columnNumber: 3
  }
}, dataViewId);
exports.DataViewId = DataViewId;
const DataViewIndexPattern = ({
  dataViewId
}) => {
  const {
    data
  } = (0, _kibana_react.useKibana)().services;
  const [indexPattern, setIndexPattern] = _react.default.useState('');
  const [hasError, setHasError] = _react.default.useState(false);
  _react.default.useEffect(() => {
    data.dataViews.get(dataViewId).then(dataView => {
      setIndexPattern(dataView.getIndexPattern());
    }).catch(() => {
      setHasError(true);
    });
  }, [data, dataViewId]);
  if (hasError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 12
      }
    }, i18n.DATA_VIEW_INDEX_PATTERN_FETCH_ERROR_MESSAGE);
  }
  if (!indexPattern) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "dataViewIndexPatternPropertyValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 5
    }
  }, indexPattern);
};
exports.DataViewIndexPattern = DataViewIndexPattern;
const Threshold = ({
  threshold
}) => {
  let thresholdDescription = (0, _fp.isEmpty)(threshold.field[0]) ? `${descriptionStepI18n.THRESHOLD_RESULTS_ALL} >= ${threshold.value}` : `${descriptionStepI18n.THRESHOLD_RESULTS_AGGREGATED_BY} ${Array.isArray(threshold.field) ? threshold.field.join(',') : threshold.field} >= ${threshold.value}`;
  if (threshold.cardinality && threshold.cardinality.length > 0) {
    thresholdDescription = descriptionStepI18n.THRESHOLD_CARDINALITY(thresholdDescription, threshold.cardinality[0].field, threshold.cardinality[0].value);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "thresholdPropertyValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 10
    }
  }, thresholdDescription);
};
exports.Threshold = Threshold;
const AnomalyThreshold = ({
  anomalyThreshold
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "anomalyThresholdPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 218,
    columnNumber: 3
  }
}, anomalyThreshold);
exports.AnomalyThreshold = AnomalyThreshold;
const MachineLearningJobList = ({
  jobIds,
  isInteractive
}) => {
  const {
    jobs: availableJobs
  } = (0, _use_security_jobs.useSecurityJobs)();
  if (!jobIds) {
    return null;
  }
  const jobIdsArray = Array.isArray(jobIds) ? jobIds : [jobIds];
  const unavailableJobIds = jobIdsArray.filter(jobId => !availableJobs.some(job => job.id === jobId));
  if (isInteractive) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ml_jobs_description.MlJobsDescription, {
      jobIds: jobIdsArray,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(UnavailableMlJobs, {
      unavailableJobIds: unavailableJobIds,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 9
      }
    }));
  }
  const relevantJobs = availableJobs.filter(job => jobIdsArray.includes(job.id));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, relevantJobs.map(job => {
    var _job$customSettings;
    return /*#__PURE__*/_react.default.createElement(_ml_job_link.MlJobLink, {
      key: job.id,
      jobId: job.id,
      jobName: (_job$customSettings = job.customSettings) === null || _job$customSettings === void 0 ? void 0 : _job$customSettings.security_app_display_name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 9
      }
    });
  }), /*#__PURE__*/_react.default.createElement(UnavailableMlJobs, {
    unavailableJobIds: unavailableJobIds,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 7
    }
  }));
};
exports.MachineLearningJobList = MachineLearningJobList;
const UnavailableMlJobs = ({
  unavailableJobIds
}) => {
  return unavailableJobIds.map(jobId => /*#__PURE__*/_react.default.createElement("div", {
    key: jobId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(UnavailableMlJobLink, {
    jobId: jobId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 7
    }
  })));
};
const UnavailableMlJobLink = ({
  jobId
}) => {
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "question",
    onClick: togglePopover,
    "aria-label": i18n.MACHINE_LEARNING_JOB_NOT_AVAILABLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "span",
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 5
    }
  }, jobId, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 7
    }
  }, i18n.MACHINE_LEARNING_JOB_NOT_AVAILABLE));
};
const getRuleTypeDescription = ruleType => {
  switch (ruleType) {
    case 'machine_learning':
      return descriptionStepI18n.ML_TYPE_DESCRIPTION;
    case 'query':
    case 'saved_query':
      return descriptionStepI18n.QUERY_TYPE_DESCRIPTION;
    case 'threshold':
      return descriptionStepI18n.THRESHOLD_TYPE_DESCRIPTION;
    case 'eql':
      return descriptionStepI18n.EQL_TYPE_DESCRIPTION;
    case 'esql':
      return descriptionStepI18n.ESQL_TYPE_DESCRIPTION;
    case 'threat_match':
      return descriptionStepI18n.THREAT_MATCH_TYPE_DESCRIPTION;
    case 'new_terms':
      return descriptionStepI18n.NEW_TERMS_TYPE_DESCRIPTION;
    default:
      return (0, _utility_types.assertUnreachable)(ruleType);
  }
};
const RuleType = ({
  type
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 330,
    columnNumber: 3
  }
}, getRuleTypeDescription(type));
exports.RuleType = RuleType;
const RequiredFields = ({
  requiredFields
}) => {
  const styles = (0, _rule_definition_section.useRequiredFieldsStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    "data-test-subj": "requiredFieldsPropertyValue",
    gutterSize: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 5
    }
  }, requiredFields.map((rF, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: rF.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_required_field_icon.RequiredFieldIcon, {
    type: rF.type,
    "data-test-subj": "field-type-icon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "requiredFieldsPropertyValueItem",
    className: styles.fieldNameText,
    grow: false,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 15
    }
  }, ` ${rF.name}${index + 1 !== requiredFields.length ? ', ' : ''}`))))));
};
exports.RequiredFields = RequiredFields;
const TimelineTitle = ({
  timelineTitle
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "timelineTemplatePropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 370,
    columnNumber: 3
  }
}, timelineTitle);
exports.TimelineTitle = TimelineTitle;
const ThreatIndex = ({
  threatIndex
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: threatIndex,
  "data-test-subj": "threatIndexPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 380,
    columnNumber: 3
  }
});
exports.ThreatIndex = ThreatIndex;
const constructThreatMappingDescription = threatMapping => {
  return threatMapping.reduce((accumThreatMaps, threatMap, threatMapIndex, {
    length: threatMappingLength
  }) => {
    const matches = threatMap.entries.reduce((accumItems, item, itemsIndex, {
      length: threatMapLength
    }) => {
      const matchOperator = item.negate ? threatMatchI18n.DOES_NOT_MATCH : threatMatchI18n.MATCHES;
      if (threatMapLength === 1) {
        return `${item.field} ${matchOperator} ${item.value}`;
      } else if (itemsIndex === 0) {
        return `(${item.field} ${matchOperator} ${item.value})`;
      } else {
        return `${accumItems} ${threatMatchI18n.AND} (${item.field} ${matchOperator} ${item.value})`;
      }
    }, '');
    if (threatMappingLength === 1) {
      return `${matches}`;
    } else if (threatMapIndex === 0) {
      return `(${matches})`;
    } else {
      return `${accumThreatMaps} ${threatMatchI18n.OR} (${matches})`;
    }
  }, '');
};
exports.constructThreatMappingDescription = constructThreatMappingDescription;
const ThreatMapping = ({
  threatMapping
}) => {
  const description = constructThreatMappingDescription(threatMapping);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "threatMappingPropertyValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 423,
      columnNumber: 5
    }
  }, description);
};
exports.ThreatMapping = ThreatMapping;
const SuppressAlertsByField = ({
  fields
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: fields,
  "data-test-subj": "alertSuppressionGroupByPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 434,
    columnNumber: 3
  }
});
exports.SuppressAlertsByField = SuppressAlertsByField;
const SuppressAlertsDuration = ({
  duration
}) => {
  const durationDescription = duration ? `${duration.value}${duration.unit}` : descriptionStepI18n.ALERT_SUPPRESSION_PER_RULE_EXECUTION;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "alertSuppressionDurationPropertyValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 447,
      columnNumber: 5
    }
  }, durationDescription);
};
exports.SuppressAlertsDuration = SuppressAlertsDuration;
const MissingFieldsStrategy = ({
  missingFieldsStrategy
}) => {
  const missingFieldsDescription = missingFieldsStrategy === _rule_schema.AlertSuppressionMissingFieldsStrategyEnum.suppress ? descriptionStepI18n.ALERT_SUPPRESSION_SUPPRESS_ON_MISSING_FIELDS : descriptionStepI18n.ALERT_SUPPRESSION_DO_NOT_SUPPRESS_ON_MISSING_FIELDS;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "alertSuppressionMissingFieldsPropertyValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 464,
      columnNumber: 5
    }
  }, missingFieldsDescription);
};
exports.MissingFieldsStrategy = MissingFieldsStrategy;
const NewTermsFields = ({
  newTermsFields
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: newTermsFields,
  "data-test-subj": "newTermsFieldsPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 475,
    columnNumber: 3
  }
});
exports.NewTermsFields = NewTermsFields;
const HistoryWindowSize = ({
  historyWindowStart
}) => {
  const size = historyWindowStart ? (0, _date_math.convertDateMathToDuration)(historyWindowStart) : _constants2.DEFAULT_HISTORY_WINDOW_SIZE;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": `newTermsWindowSizePropertyValue-${historyWindowStart}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 488,
      columnNumber: 5
    }
  }, size);
};
exports.HistoryWindowSize = HistoryWindowSize;
// eslint-disable-next-line complexity
const prepareDefinitionSectionListItems = ({
  rule,
  isInteractive,
  savedQuery,
  isSuppressionEnabled
}) => {
  var _rule$filters;
  const definitionSectionListItems = [];
  if ('index' in rule && rule.index && rule.index.length > 0) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "indexPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 513,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: i18n.INDEX_FIELD_LABEL,
        fieldName: "data_source",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 514,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(Index, {
        index: rule.index,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 517,
          columnNumber: 20
        }
      })
    });
  }
  if ('data_view_id' in rule && rule.data_view_id) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "dataViewIdPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 525,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: i18n.DATA_VIEW_ID_FIELD_LABEL,
        fieldName: "data_source",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 526,
          columnNumber: 13
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(DataViewId, {
        dataViewId: rule.data_view_id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 529,
          columnNumber: 22
        }
      })
    }, {
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "dataViewIndexPatternPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 533,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: i18n.DATA_VIEW_INDEX_PATTERN_FIELD_LABEL,
        fieldName: "data_source",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 534,
          columnNumber: 13
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(DataViewIndexPattern, {
        dataViewId: rule.data_view_id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 540,
          columnNumber: 22
        }
      })
    });
  }
  if (savedQuery) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "savedQueryNamePropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 549,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: descriptionStepI18n.SAVED_QUERY_NAME_LABEL,
        fieldName: "kql_query",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 550,
          columnNumber: 13
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(SavedQueryName, {
        savedQueryName: savedQuery.attributes.title,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 556,
          columnNumber: 22
        }
      })
    }, {
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "savedQueryLanguagePropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 560,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: i18n.SAVED_QUERY_LANGUAGE_LABEL,
        fieldName: "kql_query",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 561,
          columnNumber: 13
        }
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "savedQueryLanguagePropertyValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 565,
          columnNumber: 11
        }
      }, (0, _helpers.getQueryLanguageLabel)(savedQuery.attributes.query.language))
    });
    if (savedQuery.attributes.filters) {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "savedQueryFiltersPropertyTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 575,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          label: descriptionStepI18n.SAVED_QUERY_FILTERS_LABEL,
          fieldName: "kql_query",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 576,
            columnNumber: 13
          }
        })),
        description: /*#__PURE__*/_react.default.createElement(Filters, {
          filters: savedQuery.attributes.filters,
          "data-test-subj": "savedQueryFiltersPropertyValue",
          dataViewId: 'data_view_id' in rule ? rule.data_view_id : undefined,
          index: 'index' in rule ? rule.index : undefined,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 583,
            columnNumber: 11
          }
        })
      });
    }
    if (typeof savedQuery.attributes.query.query === 'string') {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "savedQueryContentPropertyTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 596,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          label: descriptionStepI18n.SAVED_QUERY_LABEL,
          fieldName: "kql_query",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 597,
            columnNumber: 13
          }
        })),
        description: /*#__PURE__*/_react.default.createElement(Query, {
          query: savedQuery.attributes.query.query,
          "data-test-subj": "savedQueryContentPropertyValue",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 601,
            columnNumber: 11
          }
        })
      });
    }
  }
  if ('filters' in rule && (_rule$filters = rule.filters) !== null && _rule$filters !== void 0 && _rule$filters.length) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "filtersPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 613,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: descriptionStepI18n.FILTERS_LABEL,
        fieldName: "kql_query",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 614,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(Filters, {
        filters: rule.filters,
        dataViewId: rule.data_view_id,
        index: rule.index,
        "data-test-subj": "filtersPropertyValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 618,
          columnNumber: 9
        }
      })
    });
  }
  if ('query' in rule && rule.query) {
    if (rule.type === 'eql') {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "eqlQueryPropertyTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 632,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          label: descriptionStepI18n.EQL_QUERY_LABEL,
          fieldName: "eql_query",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 633,
            columnNumber: 13
          }
        })),
        description: /*#__PURE__*/_react.default.createElement(Query, {
          query: rule.query,
          "data-test-subj": "eqlQueryPropertyValue",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 636,
            columnNumber: 22
          }
        })
      });
    } else if (rule.type === 'esql') {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "esqlQueryPropertyTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 641,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          label: descriptionStepI18n.ESQL_QUERY_LABEL,
          fieldName: "esql_query",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 642,
            columnNumber: 13
          }
        })),
        description: /*#__PURE__*/_react.default.createElement(Query, {
          query: rule.query,
          "data-test-subj": "esqlQueryPropertyValue",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 645,
            columnNumber: 22
          }
        })
      });
    } else {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "customQueryPropertyTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 651,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          label: descriptionStepI18n.QUERY_LABEL,
          fieldName: "kql_query",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 652,
            columnNumber: 15
          }
        })),
        description: /*#__PURE__*/_react.default.createElement(Query, {
          query: rule.query,
          "data-test-subj": "customQueryPropertyValue",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 655,
            columnNumber: 24
          }
        })
      }, {
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "customQueryLanguagePropertyTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 659,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          label: i18n.QUERY_LANGUAGE_LABEL,
          fieldName: "kql_query",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 660,
            columnNumber: 15
          }
        })),
        description: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "customQueryLanguagePropertyValue",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 664,
            columnNumber: 13
          }
        }, (0, _helpers.getQueryLanguageLabel)(rule.language || ''))
      });
    }
  }
  if (rule.event_category_override) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eqlOptionsEventCategoryOverrideTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 676,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: _translations5.EQL_OPTIONS_EVENT_CATEGORY_FIELD_LABEL,
        fieldName: "eql_query",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 677,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eqlOptionsEventCategoryOverrideValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 681,
          columnNumber: 9
        }
      }, rule.event_category_override)
    });
  }
  if (rule.tiebreaker_field) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eqlOptionsTiebreakerFieldTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 691,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: _translations5.EQL_OPTIONS_EVENT_TIEBREAKER_FIELD_LABEL,
        fieldName: "eql_query",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 692,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eqlOptionsEventTiebreakerFieldValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 696,
          columnNumber: 9
        }
      }, rule.tiebreaker_field)
    });
  }
  if (rule.timestamp_field) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eqlOptionsTimestampFieldTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 706,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: _translations5.EQL_OPTIONS_EVENT_TIMESTAMP_FIELD_LABEL,
        fieldName: "eql_query",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 707,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "eqlOptionsTimestampFieldValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 711,
          columnNumber: 9
        }
      }, rule.timestamp_field)
    });
  }
  if (rule.type) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "type",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 720,
          columnNumber: 14
        }
      }),
      description: /*#__PURE__*/_react.default.createElement(RuleType, {
        type: rule.type,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 721,
          columnNumber: 20
        }
      })
    });
  }
  if ('anomaly_threshold' in rule && rule.anomaly_threshold) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "anomalyThresholdPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 728,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "anomaly_threshold",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 729,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(AnomalyThreshold, {
        anomalyThreshold: rule.anomaly_threshold,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 732,
          columnNumber: 20
        }
      })
    });
  }
  if ('machine_learning_job_id' in rule) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "mlJobPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 739,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "machine_learning_job_id",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 740,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(MachineLearningJobList, {
        jobIds: rule.machine_learning_job_id,
        isInteractive: isInteractive,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 744,
          columnNumber: 9
        }
      })
    });
  }
  if (rule.related_integrations && rule.related_integrations.length > 0) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "relatedIntegrationsPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 755,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "related_integrations",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 756,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_integrations_description.RelatedIntegrationsDescription, {
        relatedIntegrations: rule.related_integrations,
        dataTestSubj: "relatedIntegrationsPropertyValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 760,
          columnNumber: 9
        }
      })
    });
  }
  if (rule.required_fields && rule.required_fields.length > 0) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "requiredFieldsPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 771,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "required_fields",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 772,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(RequiredFields, {
        requiredFields: rule.required_fields,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 775,
          columnNumber: 20
        }
      })
    });
  }
  definitionSectionListItems.push({
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "timelineTemplatePropertyTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 781,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      fieldName: "timeline_template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 782,
        columnNumber: 9
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(TimelineTitle, {
      timelineTitle: rule.timeline_title || timelinesI18n.DEFAULT_TIMELINE_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 786,
        columnNumber: 7
      }
    })
  });
  if ('threshold' in rule && rule.threshold) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "thresholdPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 793,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "threshold",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 794,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(Threshold, {
        threshold: rule.threshold,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 797,
          columnNumber: 20
        }
      })
    });
  }
  if ('threat_index' in rule && rule.threat_index) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatIndexPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 804,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "threat_index",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 805,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(ThreatIndex, {
        threatIndex: rule.threat_index,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 808,
          columnNumber: 20
        }
      })
    });
  }
  if ('threat_filters' in rule && rule.threat_filters && rule.threat_filters.length > 0) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatFiltersPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 815,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: i18n.THREAT_FILTERS_FIELD_LABEL,
        fieldName: "threat_query",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 816,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(Filters, {
        filters: rule.threat_filters,
        dataViewId: rule.data_view_id,
        index: rule.index,
        "data-test-subj": "threatFiltersPropertyValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 820,
          columnNumber: 9
        }
      })
    });
  }
  if ('threat_query' in rule && rule.threat_query) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatQueryPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 833,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: descriptionStepI18n.THREAT_QUERY_LABEL,
        fieldName: "threat_query",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 834,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(Query, {
        query: rule.threat_query,
        "data-test-subj": "threatQueryPropertyValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 837,
          columnNumber: 20
        }
      })
    });
  }
  if ('threat_language' in rule && rule.threat_language) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatQueryLanguagePropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 844,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        label: i18n.THREAT_QUERY_LANGUAGE_LABEL,
        fieldName: "threat_query",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 845,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatQueryLanguagePropertyValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 849,
          columnNumber: 9
        }
      }, (0, _helpers.getQueryLanguageLabel)(rule.threat_language))
    });
  }
  if ('threat_mapping' in rule && rule.threat_mapping) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatMappingPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 859,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "threat_mapping",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 860,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(ThreatMapping, {
        threatMapping: rule.threat_mapping,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 863,
          columnNumber: 20
        }
      })
    });
  }
  if ('new_terms_fields' in rule && rule.new_terms_fields && rule.new_terms_fields.length > 0) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "newTermsFieldsPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 870,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "new_terms_fields",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 871,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(NewTermsFields, {
        newTermsFields: rule.new_terms_fields,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 874,
          columnNumber: 20
        }
      })
    });
  }
  if ('history_window_start' in rule) {
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "newTermsWindowSizePropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 881,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "history_window_start",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 882,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(HistoryWindowSize, {
        historyWindowStart: rule.history_window_start,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 885,
          columnNumber: 20
        }
      })
    });
  }
  if (isSuppressionEnabled && 'alert_suppression' in rule && rule.alert_suppression) {
    if ('group_by' in rule.alert_suppression) {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "alertSuppressionGroupByPropertyTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 893,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
          label: i18n.SUPPRESS_ALERTS_BY_FIELD_LABEL,
          ruleType: rule.type,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 894,
            columnNumber: 13
          }
        })),
        description: /*#__PURE__*/_react.default.createElement(SuppressAlertsByField, {
          fields: rule.alert_suppression.group_by,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 900,
            columnNumber: 22
          }
        })
      });
    }
    definitionSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "alertSuppressionDurationPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 906,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
        label: i18n.SUPPRESS_ALERTS_DURATION_FIELD_LABEL,
        ruleType: rule.type,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 907,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(SuppressAlertsDuration, {
        duration: rule.alert_suppression.duration,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 913,
          columnNumber: 20
        }
      })
    });
    if ('missing_fields_strategy' in rule.alert_suppression) {
      definitionSectionListItems.push({
        title: /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "alertSuppressionMissingFieldPropertyTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 919,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
          label: i18n.SUPPRESSION_FIELD_MISSING_FIELD_LABEL,
          ruleType: rule.type,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 920,
            columnNumber: 13
          }
        })),
        description: /*#__PURE__*/_react.default.createElement(MissingFieldsStrategy, {
          missingFieldsStrategy: rule.alert_suppression.missing_fields_strategy,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 927,
            columnNumber: 11
          }
        })
      });
    }
  }
  return definitionSectionListItems;
};
const RuleDefinitionSection = ({
  rule,
  isInteractive = false,
  columnWidths = _constants.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
  dataTestSubj,
  ...descriptionListProps
}) => {
  var _descriptionListProps, _descriptionListProps2;
  const {
    savedQuery
  } = (0, _use_get_saved_query.useGetSavedQuery)({
    savedQueryId: rule.type === 'saved_query' ? rule.saved_id : '',
    ruleType: rule.type
  });
  const {
    isSuppressionEnabled
  } = (0, _use_alert_suppression.useAlertSuppression)(rule.type);
  const definitionSectionListItems = prepareDefinitionSectionListItems({
    rule,
    isInteractive,
    savedQuery,
    isSuppressionEnabled
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 968,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, (0, _extends2.default)({
    type: (_descriptionListProps = descriptionListProps.type) !== null && _descriptionListProps !== void 0 ? _descriptionListProps : 'column',
    rowGutterSize: (_descriptionListProps2 = descriptionListProps.rowGutterSize) !== null && _descriptionListProps2 !== void 0 ? _descriptionListProps2 : 'm',
    listItems: definitionSectionListItems,
    columnWidths: columnWidths,
    "data-test-subj": "listItemColumnStepRuleDescription"
  }, descriptionListProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 969,
      columnNumber: 7
    }
  })));
};
exports.RuleDefinitionSection = RuleDefinitionSection;