"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiffView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = require("@emotion/react");
var _reactDiffView = require("react-diff-view");
require("react-diff-view/style/index.css");
var _unidiff = _interopRequireDefault(require("unidiff"));
var _eui = require("@elastic/eui");
var _hunks = require("./hunks");
var _mark_edits = require("./mark_edits");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/json_diff/diff_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * @param {HunkData[]} hunks - An array of hunk objects representing changes in a section of a string. Sections normally span multiple lines.
 * @param {string} oldSource - Original string, before changes
 * @returns {UseExpandReturn} - "expandRange" is function that triggers expansion, "hunks" is an array of hunks with hidden section expanded.
 *
 * @description
 * Sections of diff without changes are hidden by default, because they are not present in the "hunks" array.
 * "useExpand" allows to show these hidden sections when user clicks on "Expand hidden <number> lines" button.
 * Calling "expandRange" basically merges two adjacent hunks into one:
 * - takes first hunk
 * - appends all the lines between the first hunk and the second hunk
 * - finally appends the second hunk
 * returned "hunks" is the resulting array of hunks with hidden section expanded.
 */
const useExpand = (hunks, oldSource) => {
  const [hunksWithSourceExpanded, expandRange] = (0, _reactDiffView.useSourceExpansion)(hunks, oldSource);
  const hunksWithMinLinesCollapsed = (0, _reactDiffView.useMinCollapsedLines)(0, hunksWithSourceExpanded, oldSource);
  return {
    expandRange,
    hunks: hunksWithMinLinesCollapsed
  };
};
const useTokens = (hunks, diffMethod, oldSource) => {
  if (!hunks) {
    return undefined;
  }
  const options = {
    oldSource,
    highlight: false,
    enhancers: [
    /*
      This custom "markEdits" function is a slightly modified version of "markEdits"
      enhancer from react-diff-view with added support for word-level highlighting.
    */
    (0, _mark_edits.markEdits)(hunks, diffMethod)]
  };
  try {
    /*
      Synchronously apply all the enhancers to the hunks and return an array of tokens.
    */
    return (0, _reactDiffView.tokenize)(hunks, options);
  } catch (ex) {
    return undefined;
  }
};
const renderGutter = ({
  change
}) => {
  /*
    Custom gutter: rendering "+" or "-" so the diff is readable by colorblind people.
  */
  if (change.type === 'insert') {
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 12
      }
    }, '+');
  }
  if (change.type === 'delete') {
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 12
      }
    }, '-');
  }
  return null;
};

/**
 * Converts an array of Change objects into a "unified diff" string.
 *
 * Takes an array of changes (as provided by the jsdiff library) and converts it into a "unified diff" string.
 *
 * @param {Change[]} changes - An array of changes between two strings.
 * @returns {string} A unified diff string representing the changes.
 */
const convertChangesToUnifiedDiffString = changes => {
  const unifiedDiff = _unidiff.default.formatLines(changes, {
    context: 3
  });
  return unifiedDiff;
};
const convertToDiffFile = (oldSource, newSource, zip) => {
  /*
    "diffLines" call converts two strings of text into an array of Change objects.
  */
  const changes = _unidiff.default.diffLines(oldSource, newSource);

  /*
    "convertChangesToUnifiedDiffString" converts an array of Change objects into a single "unified diff" string.
    More info about the "unified diff" format: https://en.wikipedia.org/wiki/Diff#Unified_format
     Unified diff is a string with change markers added. Looks something like:
    `
      @@ -3,16 +3,15 @@
         "author": ["Elastic"],
      -  "from": "now-540s",
      +  "from": "now-9m",
         "history_window_start": "now-14d",
    `
  */
  const unifiedDiff = convertChangesToUnifiedDiffString(changes);

  /*
    "parseDiff" converts a unified diff string into a gitdiff-parser File object.
     File object contains some metadata and the "hunks" property - an array of Hunk objects.
    Hunks represent changed lines of code plus a few unchanged lines above and below for context.
  */
  const [diffFile] = (0, _reactDiffView.parseDiff)(unifiedDiff, {
    nearbySequences: zip ? 'zip' : undefined
  });
  return diffFile;
};
const CustomStyles = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const customCss = (0, _react2.css)`
    .${_constants.CODE_CLASS_NAME}.diff-code {
      padding: 0 ${euiTheme.size.l} 0 ${euiTheme.size.m};
    }

    /* Gutter - a narrow column on the left-hand side that displays either a "+" or a "-" */
    .${_constants.TABLE_CLASS_NAME} .diff-gutter-col {
      width: ${euiTheme.size.xl};
    }

    /*
      Hide the redundant second gutter column in "unified" view.
      Hiding it with "display: none" would break the layout, so we set its width to 0 and make its content invisible.
    */
    .${_constants.TABLE_CLASS_NAME}.diff-unified .diff-gutter-col + .diff-gutter-col {
      width: 0;
    }
    .${_constants.TABLE_CLASS_NAME}.diff-unified .diff-gutter + .diff-gutter {
      visibility: hidden;
    }

    /* Vertical line separating two sides of the diff view */
    .${_constants.GUTTER_CLASS_NAME}:nth-child(3) {
      border-left: 1px solid ${euiTheme.colors.mediumShade};
    }

    .${_constants.GUTTER_CLASS_NAME}.diff-gutter-delete, .${_constants.GUTTER_CLASS_NAME}.diff-gutter-insert {
      font-weight: bold;
      text-align: center;
    }

    /* Gutter of a line with deletions */
    .${_constants.GUTTER_CLASS_NAME}.diff-gutter-delete {
      background: ${_constants.COLORS.light.gutterBackground.deletion};
    }
    .${_constants.DARK_THEME_CLASS_NAME} .${_constants.GUTTER_CLASS_NAME}.diff-gutter-delete {
      background: ${_constants.COLORS.dark.gutterBackground.deletion};
    }

    /* Gutter of a line with insertions */
    .${_constants.GUTTER_CLASS_NAME}.diff-gutter-insert {
      background: ${_constants.COLORS.light.gutterBackground.insertion};
    }
    .${_constants.DARK_THEME_CLASS_NAME} .${_constants.GUTTER_CLASS_NAME}.diff-gutter-insert {
      background: ${_constants.COLORS.dark.gutterBackground.insertion};
    }

    /* Background of a line with deletions */
    .${_constants.CODE_CLASS_NAME}.diff-code-delete {
      background: ${_constants.COLORS.light.lineBackground.deletion};
    }
    .${_constants.DARK_THEME_CLASS_NAME} .${_constants.CODE_CLASS_NAME}.diff-code-delete {
      background: ${_constants.COLORS.dark.lineBackground.deletion};
    }

    /* Background of a line with insertions */
    .${_constants.CODE_CLASS_NAME}.diff-code-insert {
      background: ${_constants.COLORS.light.lineBackground.insertion};
    }
    .${_constants.DARK_THEME_CLASS_NAME} .${_constants.CODE_CLASS_NAME}.diff-code-insert {
      background: ${_constants.COLORS.dark.lineBackground.insertion};
    }

    /* Accented background of removed characters / words */
    .${_constants.CODE_CLASS_NAME}.diff-code-delete .diff-code-edit {
      font-weight: 700;
      background: ${_constants.COLORS.light.characterBackground.deletion};
    }
    .${_constants.DARK_THEME_CLASS_NAME} .${_constants.CODE_CLASS_NAME}.diff-code-delete .diff-code-edit {
      background: ${_constants.COLORS.dark.characterBackground.deletion};
    }

    /* Accented background of inserted characters / words */
    .${_constants.CODE_CLASS_NAME}.diff-code-insert .diff-code-edit {
      font-weight: 700;
      background: ${_constants.COLORS.light.characterBackground.insertion};
    }
    .${_constants.DARK_THEME_CLASS_NAME} .${_constants.CODE_CLASS_NAME}.diff-code-insert .diff-code-edit {
      background: ${_constants.COLORS.dark.characterBackground.insertion};
    }
  `;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: customCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }), children);
};
const DiffView = ({
  oldSource,
  newSource,
  diffMethod = _mark_edits.DiffMethod.WORDS_WITH_SPACE,
  viewType = 'split',
  zip = false,
  'data-test-subj': dataTestSubj
}) => {
  /*
    "react-diff-view" components consume diffs not as a strings, but as something they call "hunks".
    So we first need to convert our "before" and "after" strings into these "hunk" objects.
    "hunks" describe changed sections of code plus a few unchanged lines above and below for context.
  */

  /*
    "diffFile" is essentially an object containing an array of hunks plus some metadata.
  */
  const diffFile = (0, _react.useMemo)(() => convertToDiffFile(oldSource, newSource, zip), [oldSource, newSource, zip]);

  /*
    Sections of diff without changes are hidden by default, because they are not present in the "hunks" array.
    "useExpand" allows to show these hidden sections when a user clicks on "Expand hidden <number> lines" button.
  */
  const {
    expandRange,
    hunks
  } = useExpand(diffFile.hunks, oldSource);

  /*
    Go over each hunk and extract tokens from it. For example, split strings into words or characters,
    so we can highlight them later.
  */
  const tokens = useTokens(hunks, diffMethod, oldSource);
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const tableClassName = (0, _classnames.default)(_constants.TABLE_CLASS_NAME, {
    [_constants.DARK_THEME_CLASS_NAME]: colorMode === _eui.COLOR_MODES_STANDARD.dark
  });
  return /*#__PURE__*/_react.default.createElement(CustomStyles, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactDiffView.Diff
  /*
  "diffType": can be either 'add', 'delete', 'modify', 'rename' or 'copy'.
  Passing 'add' or 'delete' would skip rendering one of the sides in split view.
  */, {
    diffType: diffFile.type,
    viewType: viewType,
    hunks: hunks,
    renderGutter: renderGutter,
    tokens: tokens,
    className: tableClassName,
    gutterClassName: _constants.GUTTER_CLASS_NAME,
    codeClassName: _constants.CODE_CLASS_NAME,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 9
    }
  }, hunks => /*#__PURE__*/_react.default.createElement(_hunks.Hunks, {
    hunks: hunks,
    oldSource: oldSource,
    expandRange: expandRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 23
    }
  }))));
};
exports.DiffView = DiffView;