"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FillGap = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_fill_gap = require("../../api/hooks/use_fill_gap");
var i18n = _interopRequireWildcard(require("./translations"));
var _telemetry = require("../../../../common/lib/telemetry");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_gaps/components/rule_gaps/fill_gap.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FillGap = ({
  isRuleEnabled,
  ruleId,
  gap
}) => {
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const isGapFillAvailable = gap.status !== _common.gapStatus.FILLED && gap.unfilled_intervals.length !== 0;
  const hasRemainingGaps = isGapFillAvailable && (gap.in_progress_intervals.length > 0 || gap.filled_intervals.length > 0);
  const fillGapMutation = (0, _use_fill_gap.useFillGapMutation)({
    onSuccess: () => {
      telemetry.reportEvent(hasRemainingGaps ? _telemetry.ManualRuleRunEventTypes.FillRemainingGap : _telemetry.ManualRuleRunEventTypes.FillGap, {
        rangeInMs: gap.total_gap_duration_ms
      });
      addSuccess(i18n.GAP_FILL_REQUEST_SUCCESS_MESSAGE, {
        toastMessage: i18n.GAP_FILL_REQUEST_SUCCESS_MESSAGE_TOOLTIP
      });
    },
    onError: error => {
      var _error$body$message, _error$body;
      addError(error, {
        title: i18n.GAP_FILL_REQUEST_ERROR_MESSAGE,
        toastMessage: (_error$body$message = error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message
      });
    }
  });
  if (!isGapFillAvailable) {
    return null;
  }
  const title = hasRemainingGaps ? i18n.GAPS_TABLE_FILL_REMAINING_GAP_BUTTON_LABEL : i18n.GAPS_TABLE_FILL_GAP_BUTTON_LABEL;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: isRuleEnabled ? '' : i18n.GAP_FILL_DISABLED_MESSAGE,
    display: "block",
    "data-test-subj": "rule-gaps-fill-gap-tooltip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: fillGapMutation.isLoading,
    isDisabled: fillGapMutation.isLoading || !isRuleEnabled,
    size: "s",
    color: "primary",
    "data-test-subj": "rule-gaps-fill-gap-button",
    onClick: () => fillGapMutation.mutate({
      ruleId,
      gapId: gap._id
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, title)));
};
exports.FillGap = FillGap;