"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDetailsPage = void 0;
var _eui = require("@elastic/eui");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _public = require("@kbn/timelines-plugin/public");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _rule_customizations_context = require("../../../rule_management/components/rule_details/rule_customizations_diff/rule_customizations_context");
var _use_group_take_action_items = require("../../../../detections/hooks/alerts_table/use_group_take_action_items");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _grouping_settings = require("../../../../detections/components/alerts_table/grouping_settings");
var _endpoint_exceptions_viewer = require("../../../endpoint_exceptions/endpoint_exceptions_viewer");
var _alerts_table = require("../../../../detections/components/alerts_table");
var _alerts_grouping = require("../../../../detections/components/alerts_table/alerts_grouping");
var _use_data_table_filters = require("../../../../common/hooks/use_data_table_filters");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _tab_navigation = require("../../../../common/components/navigation/tab_navigation");
var _constants = require("../../../../common/store/inputs/constants");
var _use_selector = require("../../../../common/hooks/use_selector");
var _kibana = require("../../../../common/lib/kibana");
var _filters_global = require("../../../../common/components/filters_global");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _search_bar = require("../../../../common/components/search_bar");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _use_lists_config = require("../../../../detections/containers/detection_engine/lists/use_lists_config");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _step_about_rule_details = require("../../../rule_creation/components/step_about_rule_details");
var _alerts_histogram_panel = require("../../../../detections/components/alerts_kpis/alerts_histogram_panel");
var _user_info = require("../../../../detections/components/user_info");
var _step_rule_actions = require("../../../rule_creation/components/step_rule_actions");
var _default_config = require("../../../../detections/components/alerts_table/default_config");
var _rule_switch = require("../../../common/components/rule_switch");
var _step_panel = require("../../../rule_creation/components/step_panel");
var _helpers2 = require("../../../common/helpers");
var _rule_info = require("../../../../detections/components/rules/rule_info");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _inputs = require("../../../../common/store/inputs");
var _actions = require("../../../../common/store/inputs/actions");
var _rule_actions_overflow = require("./rule_actions_overflow");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _has_ml_admin_permissions = require("../../../../../common/machine_learning/has_ml_admin_permissions");
var _has_ml_license = require("../../../../../common/machine_learning/has_ml_license");
var _types = require("../../../../app/types");
var _constants2 = require("../../../../../common/constants");
var _use_full_screen = require("../../../../common/containers/use_full_screen");
var _display = require("../../../../explore/hosts/pages/display");
var _helpers3 = require("../../../../timelines/components/timeline/helpers");
var _containers = require("../../../../sourcerer/containers");
var _model = require("../../../../sourcerer/store/model");
var _privileges = require("../../../../common/utils/privileges");
var _rule_execution_status = require("../../../common/components/rule_execution_status");
var _rule_monitoring = require("../../../rule_monitoring");
var _execution_log_table = require("./execution_log_table/execution_log_table");
var _rule_backfills_info = require("../../../rule_gaps/components/rule_backfills_info");
var _rule_gaps = require("../../../rule_gaps/components/rule_gaps");
var ruleI18n = _interopRequireWildcard(require("../../../common/translations"));
var _rule_details_context = require("./rule_details_context");
var _legacy_url_conflict_callout = require("./legacy_url_conflict_callout");
var i18n = _interopRequireWildcard(require("./translations"));
var _need_admin_for_update_rules_callout = require("../../../rule_management/components/callouts/need_admin_for_update_rules_callout");
var _missing_privileges = require("../../../../common/components/missing_privileges");
var _use_rule_with_fallback = require("../../../rule_management/logic/use_rule_with_fallback");
var _alerts_filter_group = require("../../../../detections/components/alerts_table/alerts_filter_group");
var _use_signal_helpers = require("../../../../sourcerer/containers/use_signal_helpers");
var _header_page = require("../../../../common/components/header_page");
var _all_exception_items_table = require("../../../rule_exceptions/components/all_exception_items_table");
var _edit_rule_settings_button_link = require("./edit_rule_settings_button_link/edit_rule_settings_button_link");
var _use_start_ml_jobs = require("../../../rule_management/logic/use_start_ml_jobs");
var _use_bulk_duplicate_confirmation = require("../../../rule_management_ui/components/rules_table/bulk_actions/use_bulk_duplicate_confirmation");
var _bulk_duplicate_exceptions_confirmation = require("../../../rule_management_ui/components/rules_table/bulk_actions/bulk_duplicate_exceptions_confirmation");
var _use_async_confirmation = require("../../../rule_management_ui/components/rules_table/rules_table/use_async_confirmation");
var _rule_snooze_badge = require("../../../rule_management/components/rule_snooze_badge");
var _use_bool_state = require("../../../../common/hooks/use_bool_state");
var _rule_definition_section = require("../../../rule_management/components/rule_details/rule_definition_section");
var _rule_schedule_section = require("../../../rule_management/components/rule_details/rule_schedule_section");
var _modified_rule_badge = require("../../../rule_management/components/rule_details/modified_rule_badge");
var _manual_rule_run = require("../../../rule_gaps/components/manual_rule_run");
var _use_manual_rule_run_confirmation = require("../../../rule_gaps/components/manual_rule_run/use_manual_rule_run_confirmation");
var _use_redirect_legacy_url = require("./use_redirect_legacy_url");
var _use_rule_details_tabs = require("./use_rule_details_tabs");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_rule_update_callout = require("../../../rule_management/hooks/use_rule_update_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_details_ui/pages/rule_details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable complexity */
// TODO: Disabling complexity is temporary till this component is refactored as part of lists UI integration
// eslint-disable-next-line no-restricted-imports
// eslint-disable-next-line no-restricted-imports
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RULE_EXCEPTION_LIST_TYPES = [_securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION, _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT];

/**
 * Need a 100% height here to account for the graph/analyze tool, which sets no explicit height parameters, but fills the available space.
 */
const StyledFullHeightContainer = _styledComponents.default.div`
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
`;

/**
 * Sets min-height on tab container to minimize page hop when switching to tabs with less content
 */
const StyledMinHeightTabContainer = _styledComponents.default.div`
  min-height: 800px;
`;

/**
 * Wrapper for the About, Definition and Schedule sections.
 * - Allows for overflow wrapping of extremely long text, that might otherwise break the layout.
 */
const RuleFieldsSectionWrapper = _styledComponents.default.div`
  overflow-wrap: anywhere;
`;
const defaultGroupingOptions = [{
  label: i18n.SOURCE_ADDRESS,
  key: 'source.address'
}, {
  label: i18n.USER_NAME,
  key: 'user.name'
}, {
  label: i18n.HOST_NAME,
  key: 'host.name'
}, {
  label: i18n.DESTINATION_ADDRESS,
  key: 'destination.address'
}];
const mapDispatchToProps = dispatch => ({
  clearSelected: ({
    id
  }) => dispatch(_securitysolutionDataTable.dataTableActions.clearSelected({
    id
  })),
  clearEventsLoading: ({
    id
  }) => dispatch(_securitysolutionDataTable.dataTableActions.clearEventsLoading({
    id
  })),
  clearEventsDeleted: ({
    id
  }) => dispatch(_securitysolutionDataTable.dataTableActions.clearEventsDeleted({
    id
  }))
});
const connector = (0, _reactRedux.connect)(null, mapDispatchToProps);
const RuleDetailsPage = exports.RuleDetailsPage = connector(/*#__PURE__*/(0, _react.memo)(function RuleDetailsPage({
  clearEventsDeleted,
  clearEventsLoading,
  clearSelected
}) {
  var _rule$rule_id, _rule$execution_summa, _lastExecution$date, _lastExecution$messag, _rule$enabled, _rule$id;
  const {
    analytics,
    i18n: i18nStart,
    theme,
    application: {
      navigateToApp,
      capabilities: {
        actions
      }
    },
    timelines: timelinesUi,
    spaces: spacesApi
  } = (0, _kibana.useKibana)().services;
  const dispatch = (0, _reactRedux.useDispatch)();
  const containerElement = (0, _react.useRef)(null);
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const updatedAt = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable;
    return ((_getTable = getTable(state, _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).updated;
  });
  const isAlertsLoading = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable2;
    return ((_getTable2 = getTable(state, _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage)) !== null && _getTable2 !== void 0 ? _getTable2 : _securitysolutionDataTable.tableDefaults).isLoading;
  });
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const [{
    loading: userInfoLoading,
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey,
    canUserCRUD,
    hasIndexRead,
    signalIndexName,
    hasIndexWrite,
    hasIndexMaintenance
  }] = (0, _user_info.useUserData)();
  const {
    loading: listsConfigLoading,
    needsConfiguration: needsListsConfiguration
  } = (0, _use_lists_config.useListsConfig)();
  const {
    sourcererDataView: oldSourcererDataViewSpec,
    loading: oldIsLoadingIndexPattern
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.detections);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.detections);
  const isLoadingIndexPattern = newDataViewPickerEnabled ? status !== 'ready' : oldIsLoadingIndexPattern;
  const loading = userInfoLoading || listsConfigLoading;
  const {
    detailName: ruleId
  } = (0, _reactRouterDom.useParams)();
  const {
    rule: maybeRule,
    refresh: refreshRule,
    loading: ruleLoading,
    isExistingRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(ruleId);
  const {
    pollForSignalIndex
  } = (0, _use_signal_helpers.useSignalHelpers)();
  const [rule, setRule] = (0, _react.useState)(null);
  const isLoading = (0, _react.useMemo)(() => ruleLoading && rule == null, [rule, ruleLoading]);
  const {
    starting: isStartingJobs,
    startMlJobs
  } = (0, _use_start_ml_jobs.useStartMlJobs)();
  const startMlJobsIfNeeded = (0, _react.useCallback)(async () => {
    if (rule) {
      await startMlJobs((0, _helpers2.getMachineLearningJobId)(rule));
    }
  }, [rule, startMlJobs]);
  const pageTabs = (0, _use_rule_details_tabs.useRuleDetailsTabs)({
    rule,
    ruleId,
    isExistingRule,
    hasIndexRead
  });
  const [isDeleteConfirmationVisible, showDeleteConfirmation, hideDeleteConfirmation] = (0, _use_bool_state.useBoolState)();
  const [confirmDeletion, handleDeletionConfirm, handleDeletionCancel] = (0, _use_async_confirmation.useAsyncConfirmation)({
    onInit: showDeleteConfirmation,
    onFinish: hideDeleteConfirmation
  });
  const {
    aboutRuleData,
    modifiedAboutRuleDetailsData,
    ruleActionsData
  } = rule != null ? (0, _helpers2.getStepsData)({
    rule,
    detailsView: true
  }) : {
    aboutRuleData: null,
    modifiedAboutRuleDetailsData: null,
    ruleActionsData: null
  };
  const {
    showBuildingBlockAlerts,
    setShowBuildingBlockAlerts,
    showOnlyThreatIndicatorAlerts
  } = (0, _use_data_table_filters.useDataTableFilters)(_securitysolutionDataTable.TableId.alertsOnRuleDetailsPage);
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const [filterGroup, setFilterGroup] = (0, _react.useState)(_securitysolutionDataTable.FILTER_OPEN);
  const storeGapsInEventLogEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('storeGapsInEventLogEnabled');
  // TODO: Refactor license check + hasMlAdminPermissions to common check
  const hasMlPermissions = (0, _has_ml_license.hasMlLicense)(mlCapabilities) && (0, _has_ml_admin_permissions.hasMlAdminPermissions)(mlCapabilities);
  const hasActionsPrivileges = (0, _react.useMemo)(() => {
    if ((rule === null || rule === void 0 ? void 0 : rule.actions) != null && (rule === null || rule === void 0 ? void 0 : rule.actions.length) > 0 && (0, _privileges.isBoolean)(actions.show)) {
      return actions.show;
    }
    return true;
  }, [actions, rule === null || rule === void 0 ? void 0 : rule.actions]);
  const navigateToAlertsTab = (0, _react.useCallback)(() => {
    navigateToApp(_constants2.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRuleDetailsTabUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '', 'alerts', '')
    });
  }, [navigateToApp, ruleId]);

  // persist rule until refresh is complete
  (0, _react.useEffect)(() => {
    if (maybeRule != null) {
      setRule(maybeRule);
    }
  }, [maybeRule]);
  (0, _use_redirect_legacy_url.useLegacyUrlRedirect)({
    rule,
    spacesApi
  });
  const showUpdating = (0, _react.useMemo)(() => isLoadingIndexPattern || isAlertsLoading || loading, [isLoadingIndexPattern, isAlertsLoading, loading]);
  const title = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rule === null || rule === void 0 ? void 0 : rule.name, " ", ruleLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 40
    }
  })), [rule, ruleLoading]);
  const badgeOptions = (0, _react.useMemo)(() => !ruleLoading && !isExistingRule ? {
    text: i18n.DELETED_RULE,
    color: 'default'
  } : undefined, [isExistingRule, ruleLoading]);
  const subTitle = (0, _react.useMemo)(() => rule ? [/*#__PURE__*/_react.default.createElement(_rule_info.CreatedBy, {
    createdBy: rule === null || rule === void 0 ? void 0 : rule.created_by,
    createdAt: rule === null || rule === void 0 ? void 0 : rule.created_at,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 13
    }
  }), (rule === null || rule === void 0 ? void 0 : rule.updated_by) != null ? /*#__PURE__*/_react.default.createElement(_rule_info.UpdatedBy, {
    updatedBy: rule === null || rule === void 0 ? void 0 : rule.updated_by,
    updatedAt: rule === null || rule === void 0 ? void 0 : rule.updated_at,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 15
    }
  }) : ''] : ruleLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 11
    }
  }) : null, [rule, ruleLoading]);

  // Callback for when open/closed filter changes
  const onFilterGroupChangedCallback = (0, _react.useCallback)(newFilterGroup => {
    const tableId = _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage;
    clearEventsLoading({
      id: tableId
    });
    clearEventsDeleted({
      id: tableId
    });
    clearSelected({
      id: tableId
    });
    setFilterGroup(newFilterGroup);
  }, [clearEventsLoading, clearEventsDeleted, clearSelected, setFilterGroup]);
  const isBuildingBlockTypeNotNull = (rule === null || rule === void 0 ? void 0 : rule.building_block_type) != null;
  // Set showBuildingBlockAlerts if rule is a Building Block Rule otherwise we won't show alerts
  (0, _react.useEffect)(() => {
    setShowBuildingBlockAlerts(isBuildingBlockTypeNotNull);
  }, [isBuildingBlockTypeNotNull, setShowBuildingBlockAlerts]);
  const ruleRuleId = (_rule$rule_id = rule === null || rule === void 0 ? void 0 : rule.rule_id) !== null && _rule$rule_id !== void 0 ? _rule$rule_id : '';
  const alertDefaultFilters = (0, _react.useMemo)(() => [...(0, _default_config.buildAlertsFilter)(ruleRuleId !== null && ruleRuleId !== void 0 ? ruleRuleId : ''), ...(0, _default_config.buildShowBuildingBlockFilter)(showBuildingBlockAlerts), ...(0, _default_config.buildAlertStatusFilter)(filterGroup), ...(0, _default_config.buildThreatMatchFilter)(showOnlyThreatIndicatorAlerts)], [ruleRuleId, showBuildingBlockAlerts, showOnlyThreatIndicatorAlerts, filterGroup]);
  const alertMergedFilters = (0, _react.useMemo)(() => [...alertDefaultFilters, ...filters], [alertDefaultFilters, filters]);
  const lastExecution = rule === null || rule === void 0 ? void 0 : (_rule$execution_summa = rule.execution_summary) === null || _rule$execution_summa === void 0 ? void 0 : _rule$execution_summa.last_execution;
  const lastExecutionStatus = lastExecution === null || lastExecution === void 0 ? void 0 : lastExecution.status;
  const lastExecutionDate = (_lastExecution$date = lastExecution === null || lastExecution === void 0 ? void 0 : lastExecution.date) !== null && _lastExecution$date !== void 0 ? _lastExecution$date : '';
  const lastExecutionMessage = (_lastExecution$messag = lastExecution === null || lastExecution === void 0 ? void 0 : lastExecution.message) !== null && _lastExecution$messag !== void 0 ? _lastExecution$messag : '';
  const upgradeCallout = (0, _use_rule_update_callout.useRuleUpdateCallout)({
    rule,
    message: ruleI18n.HAS_RULE_UPDATE_DETAILS_CALLOUT_MESSAGE,
    onUpgrade: refreshRule
  });
  const ruleStatusInfo = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ruleLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 446,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": "rule-status-loader",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 447,
        columnNumber: 15
      }
    })) : /*#__PURE__*/_react.default.createElement(_rule_execution_status.RuleStatus, {
      status: lastExecutionStatus,
      date: lastExecutionDate,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 450,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "ruleLastExecutionStatusRefreshButton",
      color: "primary",
      onClick: refreshRule,
      iconType: "refresh",
      "aria-label": ruleI18n.REFRESH,
      isDisabled: !isExistingRule,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 451,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 461,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_snooze_badge.RuleSnoozeBadge, {
      ruleId: ruleId,
      showTooltipInline: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 462,
        columnNumber: 13
      }
    })));
  }, [ruleId, lastExecutionStatus, lastExecutionDate, ruleLoading, isExistingRule, refreshRule]);

  // Extract rule index if available on rule type
  let ruleIndex;
  if (rule != null && 'index' in rule && Array.isArray(rule.index)) {
    ruleIndex = rule.index;
  }
  const ruleError = (0, _react.useMemo)(() => {
    var _rule$name;
    return ruleLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 476,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": "rule-status-loader",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 477,
        columnNumber: 11
      }
    })) : /*#__PURE__*/_react.default.createElement(_rule_execution_status.RuleStatusFailedCallOut, {
      ruleNameForChat: (_rule$name = rule === null || rule === void 0 ? void 0 : rule.name) !== null && _rule$name !== void 0 ? _rule$name : ruleI18n.DETECTION_RULES_CONVERSATION_ID,
      ruleName: rule !== null && rule !== void 0 && rule.immutable ? rule === null || rule === void 0 ? void 0 : rule.name : undefined,
      dataSources: rule !== null && rule !== void 0 && rule.immutable ? ruleIndex : undefined,
      status: lastExecutionStatus,
      date: lastExecutionDate,
      message: lastExecutionMessage,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 480,
        columnNumber: 9
      }
    });
  }, [lastExecutionStatus, lastExecutionDate, lastExecutionMessage, ruleLoading, rule === null || rule === void 0 ? void 0 : rule.immutable, rule === null || rule === void 0 ? void 0 : rule.name, ruleIndex]);
  const updateDateRangeCallback = (0, _react.useCallback)(({
    x
  }) => {
    if (!x) {
      return;
    }
    const [min, max] = x;
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: new Date(min).toISOString(),
      to: new Date(max).toISOString()
    }));
  }, [dispatch]);
  const handleOnChangeEnabledRule = (0, _react.useCallback)(enabled => {
    setRule(currentRule => currentRule ? {
      ...currentRule,
      enabled
    } : currentRule);
  }, []);
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers3.focusUtilityBarAction)(containerElement.current);
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers3.resetKeyboardFocus)();
  }, []);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers3.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  const currentAlertStatusFilterValue = (0, _react.useMemo)(() => [filterGroup], [filterGroup]);
  const updatedAtValue = (0, _react.useMemo)(() => {
    return timelinesUi.getLastUpdated({
      updatedAt: updatedAt || Date.now(),
      showUpdating
    });
  }, [updatedAt, showUpdating, timelinesUi]);
  const renderGroupedAlertTable = (0, _react.useCallback)(groupingFilters => {
    return /*#__PURE__*/_react.default.createElement(_alerts_table.AlertsTable, {
      tableType: _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage,
      inputFilters: [...alertMergedFilters, ...groupingFilters],
      onRuleChange: refreshRule,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 552,
        columnNumber: 11
      }
    });
  }, [alertMergedFilters, refreshRule]);
  const {
    isBulkDuplicateConfirmationVisible,
    showBulkDuplicateConfirmation,
    cancelRuleDuplication,
    confirmRuleDuplication
  } = (0, _use_bulk_duplicate_confirmation.useBulkDuplicateExceptionsConfirmation)();
  const {
    isManualRuleRunConfirmationVisible,
    showManualRuleRunConfirmation,
    cancelManualRuleRun,
    confirmManualRuleRun
  } = (0, _use_manual_rule_run_confirmation.useManualRuleRunConfirmation)();
  const groupTakeActionItems = (0, _use_group_take_action_items.useGroupTakeActionsItems)({
    currentStatus: currentAlertStatusFilterValue,
    showAlertStatusActions: Boolean(hasIndexWrite) && Boolean(hasIndexMaintenance)
  });
  const accordionExtraActionGroupStats = (0, _react.useMemo)(() => ({
    aggregations: _grouping_settings.defaultGroupStatsAggregations,
    renderer: _grouping_settings.defaultGroupStatsRenderer
  }), []);
  if ((0, _helpers2.redirectToDetections)(isSignalIndexExists, isAuthenticated, hasEncryptionKey, needsListsConfiguration)) {
    navigateToApp(_constants2.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.alerts,
      path: (0, _redirect_to_detection_engine.getDetectionEngineUrl)()
    });
    return null;
  }
  const defaultRuleStackByOption = 'event.category';
  const hasNotificationActions = ruleActionsData != null && ruleActionsData.actions.length > 0;
  const hasResponseActions = ruleActionsData != null && (ruleActionsData.responseActions || []).length > 0;
  const hasActions = hasNotificationActions || hasResponseActions;
  const isRuleEnabled = isExistingRule && ((_rule$enabled = rule === null || rule === void 0 ? void 0 : rule.enabled) !== null && _rule$enabled !== void 0 ? _rule$enabled : false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_need_admin_for_update_rules_callout.NeedAdminForUpdateRulesCallOut, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 615,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_missing_privileges.MissingPrivilegesCallOut, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 616,
      columnNumber: 9
    }
  }), upgradeCallout, isBulkDuplicateConfirmationVisible && /*#__PURE__*/_react.default.createElement(_bulk_duplicate_exceptions_confirmation.BulkActionDuplicateExceptionsConfirmation, {
    onCancel: cancelRuleDuplication,
    onConfirm: confirmRuleDuplication,
    rulesCount: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 619,
      columnNumber: 11
    }
  }), isDeleteConfirmationVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: ruleI18n.SINGLE_DELETE_CONFIRMATION_TITLE,
    onCancel: handleDeletionCancel,
    onConfirm: () => handleDeletionConfirm(),
    confirmButtonText: ruleI18n.DELETE_CONFIRMATION_CONFIRM,
    cancelButtonText: ruleI18n.DELETE_CONFIRMATION_CANCEL,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    "data-test-subj": "deleteRulesConfirmationModal",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 626,
      columnNumber: 11
    }
  }, i18n.DELETE_CONFIRMATION_BODY), isManualRuleRunConfirmationVisible && /*#__PURE__*/_react.default.createElement(_manual_rule_run.ManualRuleRunModal, {
    onCancel: cancelManualRuleRun,
    onConfirm: confirmManualRuleRun,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 640,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(StyledFullHeightContainer, {
    onKeyDown: onKeyDown,
    ref: containerElement,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 642,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 643,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 644,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants.InputsModelId.global,
    pollForSignalIndex: pollForSignalIndex,
    sourcererDataView: newDataViewPickerEnabled ? experimentalDataView : oldSourcererDataViewSpec,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 645,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_rule_details_context.RuleDetailsContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 653,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_customizations_context.RuleCustomizationsContextProvider, {
    rule: rule,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 654,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 655,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 656,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: true,
    subtitle: subTitle,
    subtitle2: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      alignItems: "center",
      justifyContent: "flexStart",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 661,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_modified_rule_badge.ModifiedRuleBadge, {
      rule: rule,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 662,
        columnNumber: 25
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 663,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 664,
        columnNumber: 27
      }
    }, _rule_execution_status.ruleStatusI18n.STATUS, ':'), ruleStatusInfo)),
    title: title,
    badgeOptions: badgeOptions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 657,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 675,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 676,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: (0, _privileges.explainLackOfPermission)(rule, hasMlPermissions, hasActionsPrivileges, canUserCRUD),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 677,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 686,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_switch.RuleSwitch, {
    id: (_rule$id = rule === null || rule === void 0 ? void 0 : rule.id) !== null && _rule$id !== void 0 ? _rule$id : '-1',
    isDisabled: !rule || !isExistingRule || !(0, _privileges.canEditRuleWithActions)(rule, hasActionsPrivileges) || !(0, _privileges.hasUserCRUDPermission)(canUserCRUD) || (0, _helpers.isMlRule)(rule === null || rule === void 0 ? void 0 : rule.type) && !hasMlPermissions,
    enabled: isRuleEnabled,
    startMlJobsIfNeeded: startMlJobsIfNeeded,
    onChange: handleOnChangeEnabledRule,
    ruleName: rule === null || rule === void 0 ? void 0 : rule.name,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 687,
      columnNumber: 29
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 701,
      columnNumber: 29
    }
  }, i18n.ENABLE_RULE)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 706,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 707,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 708,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_edit_rule_settings_button_link.EditRuleSettingButtonLink, {
    ruleId: ruleId,
    disabled: !isExistingRule || !(0, _privileges.hasUserCRUDPermission)(canUserCRUD) || (0, _helpers.isMlRule)(rule === null || rule === void 0 ? void 0 : rule.type) && !hasMlPermissions,
    disabledReason: (0, _privileges.explainLackOfPermission)(rule, hasMlPermissions, hasActionsPrivileges, canUserCRUD),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 709,
      columnNumber: 29
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 724,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_actions_overflow.RuleActionsOverflow, {
    rule: rule,
    userHasPermissions: isExistingRule && (0, _privileges.hasUserCRUDPermission)(canUserCRUD),
    canDuplicateRuleWithActions: (0, _privileges.canEditRuleWithActions)(rule, hasActionsPrivileges),
    showBulkDuplicateExceptionsConfirmation: showBulkDuplicateConfirmation,
    showManualRuleRunConfirmation: showManualRuleRunConfirmation,
    confirmDeletion: confirmDeletion,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 725,
      columnNumber: 29
    }
  })))))), ruleError, /*#__PURE__*/_react.default.createElement(_legacy_url_conflict_callout.LegacyUrlConflictCallOut, {
    rule: rule,
    spacesApi: spacesApi,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 746,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 747,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(RuleFieldsSectionWrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 748,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 749,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "aboutRule",
    component: "section",
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 750,
      columnNumber: 23
    }
  }, rule !== null && /*#__PURE__*/_react.default.createElement(_step_about_rule_details.StepAboutRuleToggleDetails, {
    loading: isLoading,
    stepData: aboutRuleData,
    stepDataDetails: modifiedAboutRuleDetailsData,
    rule: rule,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 752,
      columnNumber: 27
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 761,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 762,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "section",
    grow: 1,
    "data-test-subj": "defineRule",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 763,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    loading: isLoading,
    title: ruleI18n.DEFINITION,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 764,
      columnNumber: 29
    }
  }, rule !== null && !isStartingJobs && /*#__PURE__*/_react.default.createElement(_rule_definition_section.RuleDefinitionSection, {
    rule: rule,
    isInteractive: true,
    dataTestSubj: "definitionRule",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 766,
      columnNumber: 33
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 774,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "schedule",
    component: "section",
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 775,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    loading: isLoading,
    title: ruleI18n.SCHEDULE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 776,
      columnNumber: 29
    }
  }, rule != null && /*#__PURE__*/_react.default.createElement(_rule_schedule_section.RuleScheduleSection, {
    rule: rule,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 777,
      columnNumber: 48
    }
  }))), hasActions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "actions",
    component: "section",
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 781,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    loading: isLoading,
    title: ruleI18n.ACTIONS,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 782,
      columnNumber: 31
    }
  }, /*#__PURE__*/_react.default.createElement(_step_rule_actions.StepRuleActionsReadOnly, {
    addPadding: false,
    defaultValues: ruleActionsData,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 783,
      columnNumber: 33
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 794,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: pageTabs,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 795,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 796,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(StyledMinHeightTabContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 798,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 799,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/rules/id/:detailName/:tabName(${_use_rule_details_tabs.RuleDetailTabs.alerts})`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 800,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 802,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 803,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_filter_group.AlertsTableFilterGroup, {
    status: filterGroup,
    onFilterGroupChanged: onFilterGroupChangedCallback,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 804,
      columnNumber: 29
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 809,
      columnNumber: 27
    }
  }, updatedAtValue)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 811,
      columnNumber: 25
    }
  }), /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 812,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_histogram_panel.AlertsHistogramPanel, {
    filters: alertMergedFilters,
    signalIndexName: signalIndexName,
    defaultStackByOption: defaultRuleStackByOption,
    updateDateRange: updateDateRangeCallback,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 813,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 819,
      columnNumber: 27
    }
  })), ruleId != null && /*#__PURE__*/_react.default.createElement(_alerts_grouping.GroupedAlertsTable, {
    accordionButtonContent: _grouping_settings.defaultGroupTitleRenderers,
    accordionExtraActionGroupStats: accordionExtraActionGroupStats,
    dataViewSpec: oldSourcererDataViewSpec // TODO: newDataViewPickerEnabled Should be removed after migrating to new data view picker
    ,
    dataView: experimentalDataView,
    defaultFilters: alertMergedFilters,
    defaultGroupingOptions: defaultGroupingOptions,
    from: from,
    globalFilters: filters,
    globalQuery: query,
    groupTakeActionItems: groupTakeActionItems,
    loading: loading,
    renderChildComponent: renderGroupedAlertTable,
    tableId: _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage,
    to: to,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 822,
      columnNumber: 27
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/rules/id/:detailName/:tabName(${_use_rule_details_tabs.RuleDetailTabs.exceptions})`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 841,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_all_exception_items_table.ExceptionsViewer, {
    rule: rule,
    listTypes: RULE_EXCEPTION_LIST_TYPES,
    onRuleChange: refreshRule,
    isViewReadOnly: !isExistingRule,
    "data-test-subj": "exceptionTab",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 842,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/rules/id/:detailName/:tabName(${_use_rule_details_tabs.RuleDetailTabs.endpointExceptions})`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 850,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_endpoint_exceptions_viewer.EndpointExceptionsViewer, {
    rule: rule,
    onRuleChange: refreshRule,
    isViewReadOnly: !isExistingRule,
    "data-test-subj": "endpointExceptionsTab",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 853,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/rules/id/:detailName/:tabName(${_use_rule_details_tabs.RuleDetailTabs.executionResults})`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 860,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_execution_log_table.ExecutionLogTable, {
    ruleId: ruleId,
    selectAlertsTab: navigateToAlertsTab,
    analytics: analytics,
    i18n: i18nStart,
    theme: theme,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 864,
      columnNumber: 25
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 871,
      columnNumber: 25
    }
  }), storeGapsInEventLogEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_rule_gaps.RuleGaps, {
    ruleId: ruleId,
    enabled: isRuleEnabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 874,
      columnNumber: 29
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 875,
      columnNumber: 29
    }
  })), /*#__PURE__*/_react.default.createElement(_rule_backfills_info.RuleBackfillsInfo, {
    ruleId: ruleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 878,
      columnNumber: 25
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/rules/id/:detailName/:tabName(${_use_rule_details_tabs.RuleDetailTabs.executionEvents})`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 881,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_monitoring.ExecutionEventsTable, {
    ruleId: ruleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 884,
      columnNumber: 23
    }
  })))))))), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.rules,
    state: {
      ruleName: rule === null || rule === void 0 ? void 0 : rule.name,
      isExistingRule
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 892,
      columnNumber: 9
    }
  }));
}));