"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MitreAttackTechniqueFields = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var Rulei18n = _interopRequireWildcard(require("../../../common/translations"));
var _add_item_form = require("../add_item_form");
var i18n = _interopRequireWildcard(require("./translations"));
var _subtechnique_fields = require("./subtechnique_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/mitre/technique_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const lazyMitreConfiguration = () => {
  /**
   * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
   * See https://webpack.js.org/api/module-methods/#magic-comments
   */
  return Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "lazy_mitre_configuration" */
  '../../../../detections/mitre/mitre_tactics_techniques')));
};
const hasSubtechniqueOptions = (subtechniquesOptions, technique) => subtechniquesOptions.some(subtechnique => subtechnique.techniqueId === technique.id);
const TechniqueContainer = _styledComponents.default.div`
  ${({
  theme
}) => (0, _styledComponents.css)`
    margin-left: 24px;
    padding-left: 24px;
    border-left: 2px solid ${theme.eui.euiColorLightestShade};
  `}
`;
const MitreAttackTechniqueFields = ({
  field,
  idAria,
  isDisabled,
  threatIndex,
  onFieldChange
}) => {
  var _values$threatIndex$t;
  const values = field.value;
  const [techniquesOptions, setTechniquesOptions] = (0, _react.useState)([]);
  const [subtechniquesOptions, setSubtechniquesOptions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    async function getMitre() {
      const mitreConfig = await lazyMitreConfiguration();
      setTechniquesOptions(mitreConfig.techniques);
      setSubtechniquesOptions(mitreConfig.subtechniques);
    }
    getMitre();
  }, []);
  const removeTechnique = (0, _react.useCallback)(index => {
    var _threats$threatIndex$;
    const threats = [...field.value];
    const techniques = (_threats$threatIndex$ = threats[threatIndex].technique) !== null && _threats$threatIndex$ !== void 0 ? _threats$threatIndex$ : [];
    techniques.splice(index, 1);
    threats[threatIndex] = {
      ...threats[threatIndex],
      technique: techniques
    };
    onFieldChange(threats);
  }, [field, threatIndex, onFieldChange]);
  const addMitreAttackTechnique = (0, _react.useCallback)(() => {
    var _threats$threatIndex$2;
    const threats = [...field.value];
    threats[threatIndex] = {
      ...threats[threatIndex],
      technique: [...((_threats$threatIndex$2 = threats[threatIndex].technique) !== null && _threats$threatIndex$2 !== void 0 ? _threats$threatIndex$2 : []), {
        id: 'none',
        name: 'none',
        reference: 'none',
        subtechnique: []
      }]
    };
    onFieldChange(threats);
  }, [field, threatIndex, onFieldChange]);
  const updateTechnique = (0, _react.useCallback)((index, optionId) => {
    var _techniquesOptions$fi, _threats$threatIndex$3;
    const threats = [...field.value];
    const {
      id,
      reference,
      name
    } = (_techniquesOptions$fi = techniquesOptions.find(t => t.id === optionId)) !== null && _techniquesOptions$fi !== void 0 ? _techniquesOptions$fi : {
      id: '',
      name: '',
      reference: ''
    };
    const technique = (_threats$threatIndex$3 = threats[threatIndex].technique) !== null && _threats$threatIndex$3 !== void 0 ? _threats$threatIndex$3 : [];
    onFieldChange([...threats.slice(0, threatIndex), {
      ...threats[threatIndex],
      technique: [...technique.slice(0, index), {
        id,
        reference,
        name,
        subtechnique: []
      }, ...technique.slice(index + 1)]
    }, ...threats.slice(threatIndex + 1)]);
  }, [field.value, techniquesOptions, threatIndex, onFieldChange]);
  const getSelectTechnique = (0, _react.useCallback)((tacticName, index, disabled, technique) => {
    const options = techniquesOptions.filter(t => t.tactics.includes((0, _fp.kebabCase)(tacticName)));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      id: "mitreAttackTechnique",
      options: [...(technique.name === 'none' ? [{
        inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.TECHNIQUE_PLACEHOLDER),
        value: 'none',
        disabled
      }] : []), ...options.map(option => ({
        inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, option.label),
        value: option.id,
        disabled
      }))],
      prepend: `${field.label} ${i18n.TECHNIQUE}`,
      "aria-label": "",
      onChange: updateTechnique.bind(null, index),
      fullWidth: true,
      valueOfSelected: technique.id,
      "data-test-subj": "mitreAttackTechnique",
      disabled: disabled,
      placeholder: i18n.TECHNIQUE_PLACEHOLDER,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }));
  }, [field.label, techniquesOptions, updateTechnique]);
  const techniques = (_values$threatIndex$t = values[threatIndex].technique) !== null && _values$threatIndex$t !== void 0 ? _values$threatIndex$t : [];
  return /*#__PURE__*/_react.default.createElement(TechniqueContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  }, techniques.map((technique, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    describedByIds: idAria ? [`${idAria} ${i18n.TECHNIQUE}`] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 15
    }
  }, getSelectTechnique(values[threatIndex].tactic.name, index, isDisabled, technique)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    isDisabled: isDisabled,
    onClick: () => removeTechnique(index),
    "aria-label": Rulei18n.DELETE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_subtechnique_fields.MitreAttackSubtechniqueFields, {
    field: field,
    idAria: idAria,
    isDisabled: isDisabled || technique.name === 'none' || hasSubtechniqueOptions(subtechniquesOptions, technique) === false,
    threatIndex: threatIndex,
    techniqueIndex: index,
    onFieldChange: onFieldChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_add_item_form.MyAddItemButton, {
    "data-test-subj": "addMitreAttackTechnique",
    onClick: addMitreAttackTechnique,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }, i18n.ADD_MITRE_TECHNIQUE));
};
exports.MitreAttackTechniqueFields = MitreAttackTechniqueFields;