"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eqlQueryValidatorFactory = eqlQueryValidatorFactory;
var _lodash = require("lodash");
var _kibana = require("../../../../../common/lib/kibana");
var _api = require("../../../../../common/hooks/eql/api");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function eqlQueryValidatorFactory({
  indexPatterns,
  dataViewId,
  eqlOptions
}) {
  return async (...args) => {
    const [{
      value
    }] = args;
    if ((0, _lodash.isEmpty)(value.query.query)) {
      return;
    }
    try {
      var _ref, _dataView$getIndexPat, _dataView$getRuntimeM;
      const {
        data
      } = _kibana.KibanaServices.get();
      const dataView = isDataViewIdValid(dataViewId) ? await data.dataViews.get(dataViewId) : undefined;
      const dataViewTitle = (_ref = (_dataView$getIndexPat = dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern()) !== null && _dataView$getIndexPat !== void 0 ? _dataView$getIndexPat : indexPatterns === null || indexPatterns === void 0 ? void 0 : indexPatterns.join(',')) !== null && _ref !== void 0 ? _ref : '';
      const runtimeMappings = (_dataView$getRuntimeM = dataView === null || dataView === void 0 ? void 0 : dataView.getRuntimeMappings()) !== null && _dataView$getRuntimeM !== void 0 ? _dataView$getRuntimeM : {};
      const response = await (0, _api.validateEql)({
        data,
        query: value.query.query,
        dataViewTitle,
        runtimeMappings,
        eqlOptions
      });
      if ((response === null || response === void 0 ? void 0 : response.valid) === false && response.error) {
        return transformEqlResponseErrorToValidationError(response.error);
      }
    } catch (error) {
      return {
        code: _api.EQL_ERROR_CODES.FAILED_REQUEST,
        message: _translations.EQL_VALIDATION_REQUEST_ERROR,
        error
      };
    }
  };
}
function transformEqlResponseErrorToValidationError(responseError) {
  if (responseError.code === _api.EQL_ERROR_CODES.FAILED_REQUEST) {
    return {
      code: _api.EQL_ERROR_CODES.FAILED_REQUEST,
      message: _translations.EQL_VALIDATION_REQUEST_ERROR,
      error: responseError.error
    };
  }
  return {
    code: responseError.code,
    message: responseError.messages.join(', ')
  };
}
function isDataViewIdValid(dataViewId) {
  return typeof dataViewId === 'string' && dataViewId !== '';
}