"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleStep = exports.DataSourceType = exports.AlertSuppressionDurationType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RuleStep = exports.RuleStep = /*#__PURE__*/function (RuleStep) {
  RuleStep["defineRule"] = "define-rule";
  RuleStep["aboutRule"] = "about-rule";
  RuleStep["scheduleRule"] = "schedule-rule";
  RuleStep["ruleActions"] = "rule-actions";
  return RuleStep;
}({});
let DataSourceType = exports.DataSourceType = /*#__PURE__*/function (DataSourceType) {
  DataSourceType["IndexPatterns"] = "indexPatterns";
  DataSourceType["DataView"] = "dataView";
  return DataSourceType;
}({});
let AlertSuppressionDurationType = exports.AlertSuppressionDurationType = /*#__PURE__*/function (AlertSuppressionDurationType) {
  AlertSuppressionDurationType["PerRuleExecution"] = "per-rule-execution";
  AlertSuppressionDurationType["PerTimePeriod"] = "per-time-period";
  return AlertSuppressionDurationType;
}({});
/**
 * add / update data source types to show XOR relationship between 'index' and 'dataViewId' fields
 * Maybe something with io-ts?
 */