"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockSourcererState = exports.mockGlobalState = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../common/notes/constants");
var _notes = require("../../notes/store/notes.slice");
var _sort = require("../../../common/api/search_strategy/hosts/model/sort");
var _constants2 = require("../store/inputs/constants");
var _search_strategy = require("../../../common/search_strategy");
var _header = require("./header");
var _constants3 = require("../../../common/constants");
var _store = require("../../explore/network/store");
var _timeline = require("../../../common/types/timeline");
var _timeline2 = require("../../../common/api/timeline");
var _reducer = require("../../management/store/reducer");
var _model = require("../../sourcerer/store/model");
var _experimental_features = require("../../../common/experimental_features");
var _helpers = require("../../sourcerer/store/helpers");
var _mock = require("../containers/source/mock");
var _store2 = require("../../explore/users/store");
var _common = require("../../../common/search_strategy/security_solution/users/common");
var _reducer2 = require("../store/grouping/reducer");
var _helpers2 = require("../../resolver/store/helpers");
var _mock_discover_state = require("./mock_discover_state");
var _mock2 = require("../../data_view_manager/redux/mock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mockFieldMap = Object.fromEntries(_mock.mockIndexFields.map(field => [field.name, field]));
const mockSourcererState = exports.mockSourcererState = {
  ..._model.initialSourcererState,
  signalIndexName: `${_constants3.DEFAULT_SIGNALS_INDEX}-spacename`,
  defaultDataView: {
    ..._model.initialSourcererState.defaultDataView,
    browserFields: _mock.mockBrowserFields,
    id: _constants3.DEFAULT_DATA_VIEW_ID,
    fields: mockFieldMap,
    loading: false,
    patternList: [..._constants3.DEFAULT_INDEX_PATTERN, `${_constants3.DEFAULT_SIGNALS_INDEX}-spacename`],
    title: [..._constants3.DEFAULT_INDEX_PATTERN, `${_constants3.DEFAULT_SIGNALS_INDEX}-spacename`].join(',')
  }
};
const mockGlobalState = exports.mockGlobalState = {
  app: {
    notesById: {
      '1': {
        created: new Date('2024-07-02T08:32:29.233Z'),
        id: '1',
        lastEdit: new Date('2024-07-02T08:32:29.233Z'),
        note: 'New Note',
        user: 'elastic',
        saveObjectId: 'c1a44f63-eb20-4c65-a050-eb9e842d8492',
        version: 'WzIyNDUsMV0=',
        eventId: '1',
        timelineId: 'some-timeline-id'
      }
    },
    errors: [{
      id: 'error-id-1',
      title: 'title-1',
      message: ['error-message-1']
    }, {
      id: 'error-id-2',
      title: 'title-2',
      message: ['error-message-2']
    }],
    enableExperimental: _experimental_features.allowedExperimentalValues
  },
  hosts: {
    page: {
      queries: {
        authentications: {
          activePage: 0,
          limit: 10
        },
        allHosts: {
          activePage: 0,
          limit: 10,
          direction: _search_strategy.Direction.desc,
          sortField: _sort.HostsFields.lastSeen
        },
        events: {
          activePage: 0,
          limit: 10
        },
        uncommonProcesses: {
          activePage: 0,
          limit: 10
        },
        anomalies: {
          jobIdSelection: [],
          intervalSelection: 'auto'
        },
        hostRisk: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.RiskScoreFields.hostRiskScore,
            direction: _search_strategy.Direction.desc
          },
          severitySelection: []
        },
        sessions: {
          activePage: 0,
          limit: 10
        }
      }
    },
    details: {
      queries: {
        authentications: {
          activePage: 0,
          limit: 10
        },
        allHosts: {
          activePage: 0,
          limit: 10,
          direction: _search_strategy.Direction.desc,
          sortField: _sort.HostsFields.lastSeen
        },
        events: {
          activePage: 0,
          limit: 10
        },
        uncommonProcesses: {
          activePage: 0,
          limit: 10
        },
        anomalies: {
          jobIdSelection: [],
          intervalSelection: 'auto'
        },
        hostRisk: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.RiskScoreFields.hostRiskScore,
            direction: _search_strategy.Direction.desc
          },
          severitySelection: []
        },
        sessions: {
          activePage: 0,
          limit: 10
        }
      }
    }
  },
  network: {
    page: {
      queries: {
        [_store.networkModel.NetworkTableType.topCountriesDestination]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.NetworkTopTablesFields.bytes_out,
            direction: _search_strategy.Direction.desc
          }
        },
        [_store.networkModel.NetworkTableType.topCountriesSource]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.NetworkTopTablesFields.bytes_out,
            direction: _search_strategy.Direction.desc
          }
        },
        [_store.networkModel.NetworkTableType.topNFlowSource]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.NetworkTopTablesFields.bytes_out,
            direction: _search_strategy.Direction.desc
          }
        },
        [_store.networkModel.NetworkTableType.topNFlowDestination]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.NetworkTopTablesFields.bytes_out,
            direction: _search_strategy.Direction.desc
          }
        },
        [_store.networkModel.NetworkTableType.dns]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.NetworkDnsFields.queryCount,
            direction: _search_strategy.Direction.desc
          },
          isPtrIncluded: false
        },
        [_store.networkModel.NetworkTableType.tls]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.NetworkTlsFields._id,
            direction: _search_strategy.Direction.desc
          }
        },
        [_store.networkModel.NetworkTableType.http]: {
          activePage: 0,
          limit: 10,
          sort: {
            direction: _search_strategy.Direction.desc
          }
        },
        [_store.networkModel.NetworkTableType.alerts]: {
          activePage: 0,
          limit: 10
        },
        [_store.networkModel.NetworkTableType.anomalies]: {
          jobIdSelection: [],
          intervalSelection: 'auto'
        }
      }
    },
    details: {
      flowTarget: _search_strategy.FlowTarget.source,
      queries: {
        [_store.networkModel.NetworkDetailsTableType.topCountriesDestination]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.NetworkTopTablesFields.bytes_out,
            direction: _search_strategy.Direction.desc
          }
        },
        [_store.networkModel.NetworkDetailsTableType.topCountriesSource]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.NetworkTopTablesFields.bytes_out,
            direction: _search_strategy.Direction.desc
          }
        },
        [_store.networkModel.NetworkDetailsTableType.topNFlowSource]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.NetworkTopTablesFields.bytes_out,
            direction: _search_strategy.Direction.desc
          }
        },
        [_store.networkModel.NetworkDetailsTableType.topNFlowDestination]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.NetworkTopTablesFields.bytes_out,
            direction: _search_strategy.Direction.desc
          }
        },
        [_store.networkModel.NetworkDetailsTableType.tls]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.NetworkTlsFields._id,
            direction: _search_strategy.Direction.desc
          }
        },
        [_store.networkModel.NetworkDetailsTableType.users]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.NetworkUsersFields.name,
            direction: _search_strategy.Direction.asc
          }
        },
        [_store.networkModel.NetworkDetailsTableType.http]: {
          activePage: 0,
          limit: 10,
          sort: {
            direction: _search_strategy.Direction.desc
          }
        },
        [_store.networkModel.NetworkTableType.anomalies]: {
          jobIdSelection: [],
          intervalSelection: 'auto'
        }
      }
    }
  },
  users: {
    page: {
      queries: {
        [_store2.usersModel.UsersTableType.allUsers]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _common.UsersFields.name,
            direction: _search_strategy.Direction.asc
          }
        },
        [_store2.usersModel.UsersTableType.authentications]: {
          activePage: 0,
          limit: 10
        },
        [_store2.usersModel.UsersTableType.anomalies]: {
          jobIdSelection: [],
          intervalSelection: 'auto'
        },
        [_store2.usersModel.UsersTableType.risk]: {
          activePage: 0,
          limit: 10,
          sort: {
            field: _search_strategy.RiskScoreFields.timestamp,
            direction: _search_strategy.Direction.asc
          },
          severitySelection: []
        },
        [_store2.usersModel.UsersTableType.events]: {
          activePage: 0,
          limit: 10
        }
      }
    },
    details: {
      queries: {
        [_store2.usersModel.UsersTableType.anomalies]: {
          jobIdSelection: [],
          intervalSelection: 'auto'
        },
        [_store2.usersModel.UsersTableType.events]: {
          activePage: 0,
          limit: 10
        }
      }
    },
    flyout: {
      queries: {
        [_store2.usersModel.UserAssetTableType.assetEntra]: {
          fields: []
        },
        [_store2.usersModel.UserAssetTableType.assetOkta]: {
          fields: []
        }
      }
    }
  },
  inputs: {
    global: {
      timerange: {
        kind: 'relative',
        fromStr: _constants3.DEFAULT_FROM,
        toStr: _constants3.DEFAULT_TO,
        from: '2020-07-07T08:20:18.966Z',
        to: '2020-07-08T08:20:18.966Z'
      },
      linkTo: [_constants2.InputsModelId.timeline, _constants2.InputsModelId.socTrends],
      queries: [],
      policy: {
        kind: _constants3.DEFAULT_INTERVAL_TYPE,
        duration: _constants3.DEFAULT_INTERVAL_VALUE
      },
      query: {
        query: '',
        language: 'kuery'
      },
      filters: []
    },
    timeline: {
      timerange: {
        kind: 'relative',
        fromStr: _constants3.DEFAULT_FROM,
        toStr: _constants3.DEFAULT_TO,
        from: '2020-07-07T08:20:18.966Z',
        to: '2020-07-08T08:20:18.966Z'
      },
      linkTo: [_constants2.InputsModelId.global, _constants2.InputsModelId.socTrends],
      queries: [],
      policy: {
        kind: _constants3.DEFAULT_INTERVAL_TYPE,
        duration: _constants3.DEFAULT_INTERVAL_VALUE
      },
      query: {
        query: '',
        language: 'kuery'
      },
      filters: []
    },
    socTrends: {
      timerange: {
        kind: 'relative',
        fromStr: _constants3.DEFAULT_FROM,
        toStr: _constants3.DEFAULT_TO,
        from: '2020-07-06T08:20:18.966Z',
        to: '2020-07-07T08:20:18.966Z'
      },
      linkTo: [_constants2.InputsModelId.global, _constants2.InputsModelId.timeline],
      policy: {
        kind: _constants3.DEFAULT_INTERVAL_TYPE,
        duration: _constants3.DEFAULT_INTERVAL_VALUE
      }
    },
    valueReport: {
      timerange: {
        kind: 'relative',
        fromStr: _constants3.DEFAULT_FROM,
        toStr: _constants3.DEFAULT_TO,
        from: '2020-07-06T08:20:18.966Z',
        to: '2020-07-07T08:20:18.966Z'
      },
      linkTo: [],
      policy: {
        kind: _constants3.DEFAULT_INTERVAL_TYPE,
        duration: _constants3.DEFAULT_INTERVAL_VALUE
      }
    }
  },
  dragAndDrop: {
    dataProviders: {}
  },
  timeline: {
    showCallOutUnauthorizedMsg: false,
    timelineById: {
      [_timeline.TimelineId.test]: {
        activeTab: _timeline.TimelineTabs.query,
        createdBy: 'elastic',
        prevActiveTab: _timeline.TimelineTabs.notes,
        dataViewId: _constants3.DEFAULT_DATA_VIEW_ID,
        deletedEventIds: [],
        documentType: '',
        queryFields: [],
        id: _timeline.TimelineId.test,
        savedObjectId: null,
        columns: _header.defaultHeaders,
        defaultColumns: _header.defaultHeaders,
        indexNames: _constants3.DEFAULT_INDEX_PATTERN,
        itemsPerPage: 5,
        dataProviders: [],
        description: '',
        eqlOptions: {
          eventCategoryField: 'event.category',
          timestampField: '@timestamp'
        },
        eventIdToNoteIds: {
          '1': ['1']
        },
        excludedRowRendererIds: [],
        highlightedDropAndProviderId: '',
        historyIds: [],
        isFavorite: false,
        isLive: false,
        kqlMode: 'filter',
        kqlQuery: {
          filterQuery: null
        },
        loadingEventIds: [],
        title: '',
        timelineType: _timeline2.TimelineTypeEnum.default,
        templateTimelineId: null,
        templateTimelineVersion: null,
        noteIds: [],
        dateRange: {
          start: '2020-07-07T08:20:18.966Z',
          end: '2020-07-08T08:20:18.966Z'
        },
        resolveTimelineConfig: undefined,
        pinnedEventIds: {},
        pinnedEventsSaveObject: {},
        selectAll: false,
        show: false,
        sort: [{
          columnId: '@timestamp',
          columnType: 'date',
          esTypes: ['date'],
          sortDirection: 'desc'
        }],
        status: _timeline2.TimelineStatusEnum.draft,
        version: null,
        selectedEventIds: {},
        isSelectAllChecked: false,
        filters: [],
        isSaving: false,
        itemsPerPageOptions: [10, 25, 50, 100],
        savedSearchId: null,
        savedSearch: null,
        isDataProviderVisible: true,
        sampleSize: 500
      }
    },
    insertTimeline: null
  },
  dataTable: {
    tableById: {
      [_securitysolutionDataTable.TableId.test]: {
        columns: _header.defaultHeaders,
        defaultColumns: _header.defaultHeaders,
        dataViewId: 'security-solution-default',
        deletedEventIds: [],
        filters: [],
        indexNames: ['.alerts-security.alerts-default'],
        isSelectAllChecked: false,
        itemsPerPage: 25,
        itemsPerPageOptions: [10, 25, 50, 100],
        loadingEventIds: [],
        selectedEventIds: {},
        showCheckboxes: false,
        sort: [{
          columnId: '@timestamp',
          columnType: 'date',
          esTypes: ['date'],
          sortDirection: 'desc'
        }],
        selectAll: false,
        id: _securitysolutionDataTable.TableId.test,
        title: '',
        initialized: true,
        updated: 1663882629000,
        isLoading: false,
        queryFields: [],
        totalCount: 0,
        viewMode: _constants3.VIEW_SELECTION.gridView,
        additionalFilters: {
          showBuildingBlockAlerts: false,
          showOnlyThreatIndicatorAlerts: false
        }
      }
    }
  },
  groups: _reducer2.initialGroupingState,
  analyzer: {
    [_securitysolutionDataTable.TableId.test]: _helpers2.EMPTY_RESOLVER,
    [_timeline.TimelineId.test]: _helpers2.EMPTY_RESOLVER,
    [_timeline.TimelineId.active]: _helpers2.EMPTY_RESOLVER,
    [`securitySolution-${_securitysolutionDataTable.TableId.test}`]: _helpers2.EMPTY_RESOLVER
  },
  sourcerer: {
    ...mockSourcererState,
    defaultDataView: {
      ...mockSourcererState.defaultDataView,
      title: `${mockSourcererState.defaultDataView.title},fakebeat-*`
    },
    kibanaDataViews: [{
      ...mockSourcererState.defaultDataView,
      title: `${mockSourcererState.defaultDataView.title},fakebeat-*`
    }],
    sourcererScopes: {
      ...mockSourcererState.sourcererScopes,
      [_model.SourcererScopeName.default]: {
        ...mockSourcererState.sourcererScopes[_model.SourcererScopeName.default],
        selectedDataViewId: mockSourcererState.defaultDataView.id,
        selectedPatterns: (0, _helpers.getScopePatternListSelection)(mockSourcererState.defaultDataView, _model.SourcererScopeName.default, mockSourcererState.signalIndexName, true)
      },
      [_model.SourcererScopeName.detections]: {
        ...mockSourcererState.sourcererScopes[_model.SourcererScopeName.detections],
        selectedDataViewId: mockSourcererState.defaultDataView.id,
        selectedPatterns: (0, _helpers.getScopePatternListSelection)(mockSourcererState.defaultDataView, _model.SourcererScopeName.detections, mockSourcererState.signalIndexName, true)
      },
      [_model.SourcererScopeName.timeline]: {
        ...mockSourcererState.sourcererScopes[_model.SourcererScopeName.timeline],
        selectedDataViewId: mockSourcererState.defaultDataView.id,
        selectedPatterns: (0, _helpers.getScopePatternListSelection)(mockSourcererState.defaultDataView, _model.SourcererScopeName.timeline, mockSourcererState.signalIndexName, true)
      },
      [_model.SourcererScopeName.analyzer]: {
        ...mockSourcererState.sourcererScopes[_model.SourcererScopeName.default],
        selectedDataViewId: mockSourcererState.defaultDataView.id,
        selectedPatterns: (0, _helpers.getScopePatternListSelection)(mockSourcererState.defaultDataView, _model.SourcererScopeName.default, mockSourcererState.signalIndexName, true)
      },
      [_model.SourcererScopeName.explore]: {
        ...mockSourcererState.sourcererScopes[_model.SourcererScopeName.default],
        selectedDataViewId: mockSourcererState.defaultDataView.id,
        selectedPatterns: (0, _helpers.getScopePatternListSelection)(mockSourcererState.defaultDataView, _model.SourcererScopeName.default, mockSourcererState.signalIndexName, true)
      }
    }
  },
  globalUrlParam: {},
  /**
   * These state's are wrapped in `Immutable`, but for compatibility with the overall app architecture,
   * they are cast to mutable versions here.
   */
  management: _reducer.mockManagementState,
  discover: (0, _mock_discover_state.getMockDiscoverInTimelineState)(),
  notes: {
    entities: {
      '1': {
        eventId: '1',
        // should be a valid id based on mockTimelineData
        noteId: '1',
        note: 'note-1',
        timelineId: 'timeline-1',
        created: 1663882629000,
        createdBy: 'elastic',
        updated: 1663882629000,
        updatedBy: 'elastic',
        version: 'version'
      }
    },
    ids: ['1'],
    status: {
      fetchNotesByDocumentIds: _notes.ReqStatus.Idle,
      fetchNotesBySavedObjectIds: _notes.ReqStatus.Idle,
      createNote: _notes.ReqStatus.Idle,
      deleteNotes: _notes.ReqStatus.Idle,
      fetchNotes: _notes.ReqStatus.Idle
    },
    error: {
      fetchNotesByDocumentIds: null,
      fetchNotesBySavedObjectIds: null,
      createNote: null,
      deleteNotes: null,
      fetchNotes: null
    },
    pagination: {
      page: 1,
      perPage: 10,
      total: 0
    },
    sort: {
      field: 'created',
      direction: 'desc'
    },
    filter: '',
    createdByFilter: '',
    associatedFilter: _constants.AssociatedFilter.all,
    search: '',
    selectedIds: [],
    pendingDeleteIds: []
  },
  ..._mock2.mockDataViewManagerState
};