"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityIntegrations = exports.DEFAULT_CHECK_COMPLETE_METADATA = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_integration_card_list = require("../hooks/use_integration_card_list");
var _security_integrations_grid_tabs = require("./security_integrations_grid_tabs");
var _with_available_packages = require("./with_available_packages");
var _use_selected_tab = require("../hooks/use_selected_tab");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/lib/integrations/components/security_integrations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_CHECK_COMPLETE_METADATA = exports.DEFAULT_CHECK_COMPLETE_METADATA = {
  activeIntegrations: [],
  isAgentRequired: false
};
const SecurityIntegrations = exports.SecurityIntegrations = (0, _with_available_packages.withAvailablePackages)(({
  availablePackages,
  topCalloutRenderer,
  checkCompleteMetadata = DEFAULT_CHECK_COMPLETE_METADATA
}) => {
  var _activeIntegrations$l;
  const {
    isAgentRequired,
    activeIntegrations
  } = checkCompleteMetadata;
  const {
    selectedTab,
    setSelectedTabId
  } = (0, _use_selected_tab.useSelectedTab)();
  const list = (0, _use_integration_card_list.useIntegrationCardList)({
    integrationsList: availablePackages.filteredCards,
    activeIntegrations,
    selectedTab
  });
  const activeIntegrationsCount = (_activeIntegrations$l = activeIntegrations === null || activeIntegrations === void 0 ? void 0 : activeIntegrations.length) !== null && _activeIntegrations$l !== void 0 ? _activeIntegrations$l : 0;
  return /*#__PURE__*/_react.default.createElement(_security_integrations_grid_tabs.SecurityIntegrationsGridTabs, {
    isAgentRequired: isAgentRequired,
    activeIntegrationsCount: activeIntegrationsCount,
    topCalloutRenderer: topCalloutRenderer,
    integrationList: list,
    availablePackages: availablePackages,
    setSelectedTabId: setSelectedTabId,
    selectedTab: selectedTab,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  });
});