"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGlobalHeaderPortal = void 0;
var _react = require("react");
var _reactReversePortal = require("react-reverse-portal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A singleton portal for rendering content in the global header
 */
const globalKQLHeaderPortalNodeSingleton = (0, _reactReversePortal.createHtmlPortalNode)();
const useGlobalHeaderPortal = () => {
  const [globalKQLHeaderPortalNode] = (0, _react.useState)(globalKQLHeaderPortalNodeSingleton);
  return {
    globalKQLHeaderPortalNode
  };
};
exports.useGlobalHeaderPortal = useGlobalHeaderPortal;