"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkGetUserProfiles = exports.bulkGetUserProfiles = void 0;
var _reactQuery = require("@kbn/react-query");
var _kibana = require("../../lib/kibana");
var _use_app_toasts = require("../../hooks/use_app_toasts");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkGetUserProfiles = async ({
  security,
  uids
}) => {
  if (uids.size === 0) {
    return [];
  }
  return security.userProfiles.bulkGet({
    uids,
    dataPath: 'avatar'
  });
};
exports.bulkGetUserProfiles = bulkGetUserProfiles;
const useBulkGetUserProfiles = ({
  uids
}) => {
  const {
    security
  } = (0, _kibana.useKibana)().services;
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useQuery)(['useBulkGetUserProfiles', ...uids], async () => {
    return bulkGetUserProfiles({
      security,
      uids
    });
  }, {
    retry: false,
    staleTime: Infinity,
    onError: e => {
      addError(e, {
        title: _translations.USER_PROFILES_FAILURE
      });
    }
  });
};
exports.useBulkGetUserProfiles = useBulkGetUserProfiles;