"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulTopN = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _common = require("@kbn/data-plugin/common");
var _helpers = require("../../../helpers");
var _constants = require("../../store/inputs/constants");
var _use_global_time = require("../../containers/use_global_time");
var _kibana = require("../../lib/kibana");
var _kuery = require("../../lib/kuery");
var _store = require("../../store");
var _defaults = require("../../../timelines/store/defaults");
var _store2 = require("../../../timelines/store");
var _helpers2 = require("./helpers");
var _top_n = require("./top_n");
var _timeline = require("../../../../common/types/timeline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/top_n/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_FILTERS = [];
const EMPTY_QUERY = {
  query: '',
  language: 'kuery'
};
const makeMapStateToProps = () => {
  const getGlobalQuerySelector = _store.inputsSelectors.globalQuerySelector();
  const getGlobalFiltersQuerySelector = _store.inputsSelectors.globalFiltersQuerySelector();
  const getTimeline = _store2.timelineSelectors.getTimelineByIdSelector();
  const getInputsTimeline = _store.inputsSelectors.getTimelineSelector();
  const getKqlQueryTimeline = _store2.timelineSelectors.getKqlFilterQuerySelector();

  // The mapped Redux state provided to this component includes the global
  // filters that appear at the top of most views in the app, and all the
  // filters in the active timeline:
  const mapStateToProps = (state, ownProps) => {
    var _getTimeline, _activeTimeline$filte;
    const activeTimeline = (_getTimeline = getTimeline(state, _timeline.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
    const activeTimelineFilters = (_activeTimeline$filte = activeTimeline.filters) !== null && _activeTimeline$filte !== void 0 ? _activeTimeline$filte : EMPTY_FILTERS;
    const activeTimelineInput = getInputsTimeline(state);
    const {
      globalFilters
    } = ownProps;
    return {
      activeTimelineEventType: activeTimeline.eventType,
      activeTimelineFilters: activeTimeline.activeTab === _timeline.TimelineTabs.query ? activeTimelineFilters : EMPTY_FILTERS,
      activeTimelineFrom: activeTimelineInput.timerange.from,
      activeTimelineKqlQueryExpression: activeTimeline.activeTab === _timeline.TimelineTabs.query ? getKqlQueryTimeline(state, _timeline.TimelineId.active) : null,
      activeTimelineTo: activeTimelineInput.timerange.to,
      dataProviders: activeTimeline.activeTab === _timeline.TimelineTabs.query ? activeTimeline.dataProviders : [],
      globalQuery: getGlobalQuerySelector(state),
      globalFilters: globalFilters !== null && globalFilters !== void 0 ? globalFilters : getGlobalFiltersQuerySelector(state),
      kqlMode: activeTimeline.kqlMode
    };
  };
  return mapStateToProps;
};
const connector = (0, _reactRedux.connect)(makeMapStateToProps);

//  * `indexToAdd`, which enables the alerts index to be appended to
//    the `indexPattern` returned by `useWithSource`, may only be populated when
//    this component is rendered in the context of the active timeline. This
//    behavior enables the 'All events' view by appending the alerts index
//    to the index pattern.

const StatefulTopNComponent = ({
  activeTimelineEventType,
  activeTimelineFilters,
  activeTimelineFrom,
  activeTimelineKqlQueryExpression,
  activeTimelineTo,
  browserFields,
  dataProviders,
  field,
  dataViewSpec,
  dataView,
  globalFilters = EMPTY_FILTERS,
  globalQuery = EMPTY_QUERY,
  kqlMode,
  onFilterAdded,
  paddingSize,
  scopeId,
  toggleTopN
}) => {
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const {
    from,
    deleteQuery,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const options = (0, _helpers2.getOptions)((0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? activeTimelineEventType : undefined);
  const applyGlobalQueriesAndFilters = !(0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '');
  const combinedQueries = (0, _react.useMemo)(() => (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? (0, _kuery.combineQueries)({
    browserFields,
    config: (0, _common.getEsQueryConfig)(uiSettings),
    dataProviders,
    filters: activeTimelineFilters,
    dataViewSpec,
    dataView,
    kqlMode,
    kqlQuery: {
      language: 'kuery',
      query: activeTimelineKqlQueryExpression !== null && activeTimelineKqlQueryExpression !== void 0 ? activeTimelineKqlQueryExpression : ''
    }
  }) : undefined, [scopeId, browserFields, uiSettings, dataProviders, activeTimelineFilters, dataViewSpec, dataView, kqlMode, activeTimelineKqlQueryExpression]);
  const defaultView = (0, _react.useMemo)(() => (0, _helpers2.isDetectionsAlertsTable)(scopeId) ? 'alert' : options[0].value, [options, scopeId]);
  return /*#__PURE__*/_react.default.createElement(_top_n.TopN, {
    filterQuery: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery,
    defaultView: defaultView,
    deleteQuery: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? undefined : deleteQuery,
    field: field,
    filters: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? EMPTY_FILTERS : globalFilters,
    from: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? activeTimelineFrom : from,
    dataView: dataView,
    dataViewSpec: dataViewSpec,
    options: options,
    paddingSize: paddingSize,
    query: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? EMPTY_QUERY : globalQuery,
    setAbsoluteRangeDatePickerTarget: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? _constants.InputsModelId.timeline : _constants.InputsModelId.global,
    scopeId: scopeId,
    to: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '') ? activeTimelineTo : to,
    toggleTopN: toggleTopN,
    onFilterAdded: onFilterAdded,
    applyGlobalQueriesAndFilters: applyGlobalQueriesAndFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 5
    }
  });
};
StatefulTopNComponent.displayName = 'StatefulTopNComponent';
const StatefulTopN = exports.StatefulTopN = connector(/*#__PURE__*/_react.default.memo(StatefulTopNComponent));