"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/toolbar/bulk_actions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BulkActionsContainer = _styledComponents.default.div`
  display: inline-block;
  position: relative;
`;
BulkActionsContainer.displayName = 'BulkActionsContainer';

/**
 * Stateless component integrating the bulk actions menu and the select all button
 */
const BulkActionsComponent = ({
  selectText,
  selectClearAllText,
  showClearSelection,
  onSelectAll,
  onClearSelection,
  bulkActionItems,
  bulkActionPanels
}) => {
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react.useState)(false);
  const toggleIsActionOpen = (0, _react.useCallback)(() => {
    setIsActionsPopoverOpen(currentIsOpen => !currentIsOpen);
  }, [setIsActionsPopoverOpen]);
  const closeActionPopover = (0, _react.useCallback)(() => {
    setIsActionsPopoverOpen(false);
  }, [setIsActionsPopoverOpen]);
  const closeIfPopoverIsOpen = (0, _react.useCallback)(() => {
    if (isActionsPopoverOpen) {
      setIsActionsPopoverOpen(false);
    }
  }, [isActionsPopoverOpen]);
  const toggleSelectAll = (0, _react.useCallback)(() => {
    if (!showClearSelection) {
      onSelectAll();
    } else {
      onClearSelection();
    }
  }, [onClearSelection, onSelectAll, showClearSelection]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    items: bulkActionItems
  }, ...bulkActionPanels], [bulkActionItems, bulkActionPanels]);
  return /*#__PURE__*/_react.default.createElement(BulkActionsContainer, {
    onClick: closeIfPopoverIsOpen,
    "data-test-subj": "bulk-actions-button-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isActionsPopoverOpen,
    anchorPosition: "upCenter",
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": "selectedShowBulkActions",
      "data-test-subj": "selectedShowBulkActionsButton",
      size: "xs",
      iconType: "arrowDown",
      iconSide: "right",
      color: "primary",
      onClick: toggleIsActionOpen,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    }, selectText),
    closePopover: closeActionPopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    size: "s",
    panels: panels,
    initialPanelId: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    "aria-label": "selectAllAlerts",
    "data-test-subj": "selectAllAlertsButton",
    iconType: showClearSelection ? 'cross' : 'pagesSelect',
    onClick: toggleSelectAll,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, selectClearAllText));
};
const BulkActions = exports.BulkActions = /*#__PURE__*/_react.default.memo(BulkActionsComponent);