"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInitialTagsState = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Sorts in order of `on` -> `mixed` -> `undefined`
const checkedSortCallback = (a, b) => {
  if (a.checked) {
    if (b.checked) {
      return a.checked <= b.checked ? 1 : -1;
    }
    return -1;
  }
  if (b.checked) {
    return 1;
  }
  return 0;
};
const createInitialTagsState = (existingTags, defaultTags) => {
  const existingTagsIntersection = (0, _lodash.intersection)(...existingTags);
  const existingTagsUnion = (0, _lodash.union)(...existingTags);
  const allTagsUnion = (0, _lodash.union)(existingTagsUnion, defaultTags);
  return allTagsUnion.map(tag => {
    let checkedStatus = {
      checked: undefined,
      'data-test-subj': 'unselected-alert-tag'
    };
    if (existingTagsIntersection.includes(tag)) {
      checkedStatus = {
        checked: 'on',
        'data-test-subj': 'selected-alert-tag'
      };
    } else if (existingTagsUnion.includes(tag)) {
      checkedStatus = {
        checked: 'mixed',
        'data-test-subj': 'mixed-alert-tag'
      };
    }
    return {
      label: tag,
      ...checkedStatus
    };
  }).sort(checkedSortCallback);
};
exports.createInitialTagsState = createInitialTagsState;