"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createKeyAndValue = exports.createInfluencers = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _fp = require("lodash/fp");
var _get_entries = require("../get_entries");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml/influencers/create_influencers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createKeyAndValue = influencer => {
  const [key, value] = (0, _get_entries.getEntries)(influencer);
  if (key != null && value != null) {
    return `${key}: "${value}"`;
  } else {
    return '';
  }
};
exports.createKeyAndValue = createKeyAndValue;
const createInfluencers = (influencers = []) => influencers.filter(influencer => !(0, _fp.isEmpty)(influencer)).map(influencer => {
  const keyAndValue = createKeyAndValue(influencer);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: keyAndValue,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  }, keyAndValue);
});
exports.createInfluencers = createInfluencers;