"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMlRuleValidations = void 0;
var _helpers = require("../../../../../common/machine_learning/helpers");
var _use_installed_security_jobs = require("./use_installed_security_jobs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to encapsulate some of our validation checks for ML rules.
 *
 * @param machineLearningJobId the ML Job IDs of the rule
 * @returns validation state about the rule, relative to its ML jobs.
 */
const useMlRuleValidations = ({
  machineLearningJobId
}) => {
  const {
    jobs: installedJobs,
    loading
  } = (0, _use_installed_security_jobs.useInstalledSecurityJobs)();
  const ruleMlJobs = installedJobs.filter(installedJob => (machineLearningJobId !== null && machineLearningJobId !== void 0 ? machineLearningJobId : []).includes(installedJob.id));
  const numberOfRuleMlJobsStarted = ruleMlJobs.filter(job => (0, _helpers.isJobStarted)(job.jobState, job.datafeedState)).length;
  const noMlJobsStarted = numberOfRuleMlJobsStarted === 0;
  const allMlJobsStarted = !noMlJobsStarted && numberOfRuleMlJobsStarted === ruleMlJobs.length;
  return {
    loading,
    noJobsStarted: noMlJobsStarted,
    allJobsStarted: allMlJobsStarted
  };
};
exports.useMlRuleValidations = useMlRuleValidations;