"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJobsSummary = void 0;
var _kibana = require("../../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches a summary of all ML jobs currently installed
 *
 * @param jobIds Array of job IDs to filter against
 * @param signal to cancel request
 *
 * @throws An error if response is not OK
 */
const getJobsSummary = async ({
  jobIds,
  signal
}) => _kibana.KibanaServices.get().http.fetch('/internal/ml/jobs/jobs_summary', {
  method: 'POST',
  version: '1',
  body: JSON.stringify({
    jobIds: jobIds !== null && jobIds !== void 0 ? jobIds : []
  }),
  asSystemRequest: true,
  signal
});
exports.getJobsSummary = getJobsSummary;