"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RouteCapture = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _types = require("../../../../common/types");
var _store = require("../../../timelines/store");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component should be used above all routes, but below the Provider.
 * It dispatches actions when the URL is changed.
 */
const RouteCapture = exports.RouteCapture = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const {
    pathname,
    search,
    hash,
    state
  } = (0, _reactRouterDom.useLocation)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const relevantUrlParams = (0, _react.useMemo)(() => ({
    pathname,
    search,
    hash,
    state
  }), [pathname, search, hash, state]);
  (0, _react.useEffect)(() => {
    dispatch(_store.timelineActions.showTimeline({
      id: _types.TimelineId.active,
      show: false
    }));
  }, [dispatch, relevantUrlParams.pathname]);
  (0, _react.useEffect)(() => {
    dispatch({
      type: 'userChangedUrl',
      payload: relevantUrlParams
    });
  }, [dispatch, relevantUrlParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
});
RouteCapture.displayName = 'RouteCapture';