"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendItem = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _translation = require("./translation");
var _validators = require("../../utils/validators");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/charts/legend_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LegendText = _styled.default.span`
  font-size: 10.5px;
`;

/**
 * Renders the value or a placeholder in case the value is empty
 */
const ValueWrapper = /*#__PURE__*/_react.default.memo(({
  value
}) => (0, _validators.hasValueToDisplay)(value) ? /*#__PURE__*/_react.default.createElement(LegendText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 5
  }
}, value) : /*#__PURE__*/_react.default.createElement(LegendText, {
  "data-test-subj": "value-wrapper-empty",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 5
  }
}, _translation.EMPTY_VALUE_LABEL));
ValueWrapper.displayName = 'ValueWrapper';
const LegendItemComponent = ({
  legendItem
}) => {
  const {
    color,
    value
  } = legendItem;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, color != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": "legend-color",
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ValueWrapper, {
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }))));
};
LegendItemComponent.displayName = 'LegendItemComponent';
const LegendItem = exports.LegendItem = /*#__PURE__*/_react.default.memo(LegendItemComponent);