"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityInsight = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _use_has_vulnerabilities = require("@kbn/cloud-security-posture/src/hooks/use_has_vulnerabilities");
var _use_has_misconfigurations = require("@kbn/cloud-security-posture/src/hooks/use_has_misconfigurations");
var _misconfiguration_preview = require("./misconfiguration/misconfiguration_preview");
var _vulnerabilities_preview = require("./vulnerabilities/vulnerabilities_preview");
var _alerts_preview = require("./alerts/alerts_preview");
var _use_global_time = require("../../common/containers/use_global_time");
var _types = require("../../overview/components/detection_response/alerts_by_status/types");
var _use_non_closed_alerts = require("../hooks/use_non_closed_alerts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/cloud_security_posture/components/entity_insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// related.entity is not an entity identifier field, but it includes entity ids which we use to filter for related entities

const EntityInsight = ({
  value,
  field,
  isPreviewMode,
  isLinkEnabled,
  openDetailsPanel
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const insightContent = [];
  const {
    hasMisconfigurationFindings: showMisconfigurationsPreview
  } = (0, _use_has_misconfigurations.useHasMisconfigurations)(field, value);
  const {
    hasVulnerabilitiesFindings
  } = (0, _use_has_vulnerabilities.useHasVulnerabilities)(field, value);
  const showVulnerabilitiesPreview = hasVulnerabilitiesFindings && field === 'host.name';
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const {
    hasNonClosedAlerts: showAlertsPreview,
    filteredAlertsData
  } = (0, _use_non_closed_alerts.useNonClosedAlerts)({
    field,
    value,
    to,
    from,
    queryId: _types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID
  });
  if (showAlertsPreview) {
    insightContent.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_alerts_preview.AlertsPreview, {
      alertsData: filteredAlertsData,
      isPreviewMode: isPreviewMode,
      isLinkEnabled: isLinkEnabled,
      openDetailsPanel: openDetailsPanel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    })));
  }
  if (showMisconfigurationsPreview) insightContent.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_misconfiguration_preview.MisconfigurationsPreview, {
    value: value,
    field: field,
    isPreviewMode: isPreviewMode,
    isLinkEnabled: isLinkEnabled,
    openDetailsPanel: openDetailsPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  })));
  if (showVulnerabilitiesPreview) insightContent.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_vulnerabilities_preview.VulnerabilitiesPreview, {
    value: value,
    field: field,
    isPreviewMode: isPreviewMode,
    isLinkEnabled: isLinkEnabled,
    openDetailsPanel: openDetailsPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, insightContent.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    id: "entityInsight-accordion",
    "data-test-subj": "entityInsightTestSubj",
    buttonProps: {
      'data-test-subj': 'entityInsight-accordion-button',
      css: (0, _react2.css)`
                color: ${euiTheme.colors.primary};
              `
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.insightsTitle",
      defaultMessage: "Insights",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 19
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }), insightContent), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  })));
};
exports.EntityInsight = EntityInsight;