"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduleField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _get_time_options = require("./get_time_options");
var _shared_imports = require("../../../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/schedule/form_fields/schedule_field/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INTEGER_REGEX = /^[1-9][0-9]*$/;
const MIN_TIME_VALUE = 1;
const DEFAULT_TIME_VALUE = 24;
const DEFAULT_TIME_UNIT = _get_time_options.TIME_UNITS.HOUR;
const ALL_UNITS = [_get_time_options.TIME_UNITS.SECOND, _get_time_options.TIME_UNITS.MINUTE, _get_time_options.TIME_UNITS.HOUR, _get_time_options.TIME_UNITS.DAY];
const ScheduleField = exports.ScheduleField = /*#__PURE__*/_react.default.memo(({
  field
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  const {
    setValue: setFieldValue,
    value: fieldValue
  } = field;
  const [timeType, setTimeType] = (0, _react.useState)(DEFAULT_TIME_UNIT);
  const [timeVal, setTimeVal] = (0, _react.useState)(DEFAULT_TIME_VALUE);
  (0, _react.useEffect)(() => {
    if (fieldValue === `${timeVal}${timeType}`) {
      return;
    }
    const isNegative = fieldValue.startsWith('-');
    const durationRegexp = new RegExp(`^\\-?(\\d+)(${ALL_UNITS.join('|')})$`);
    const durationMatchArray = fieldValue.match(durationRegexp);
    if (!durationMatchArray) {
      return;
    }
    const [, timeStr, unit] = durationMatchArray;
    const time = parseInt(timeStr, 10) * (isNegative ? -1 : 1);
    setTimeVal(time);
    setTimeType(unit);
  }, [timeType, timeVal, fieldValue]);
  const onIntervalNumberChange = (0, _react.useCallback)(e => {
    const value = e.target.value.trim();
    if (INTEGER_REGEX.test(value)) {
      const parsedValue = Math.max(MIN_TIME_VALUE, parseInt(value, 10));
      setTimeVal(parsedValue);
      setFieldValue(`${parsedValue}${timeType}`);
    }
  }, [setFieldValue, timeType]);
  const onIntervalUnitChange = (0, _react.useCallback)(e => {
    setTimeType(e.target.value);
    setFieldValue(`${timeVal}${e.target.value}`);
  }, [setFieldValue, timeVal]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: field.label,
    labelAppend: field.labelAppend,
    helpText: field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    fullWidth: true,
    "data-test-subj": "attackDiscoveryScheduleField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    value: timeVal,
    name: "interval",
    "data-test-subj": "scheduleNumberInput",
    onChange: onIntervalNumberChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    value: timeType,
    options: (0, _get_time_options.getTimeOptions)(timeVal !== null && timeVal !== void 0 ? timeVal : 1),
    onChange: onIntervalUnitChange,
    "data-test-subj": "scheduleUnitInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }))));
});
ScheduleField.displayName = 'ScheduleField';