"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetInventoryRoutes = void 0;
var _react = require("react");
var _constants = require("../../../common/api/asset_inventory/constants");
var _constants2 = require("../../../common/constants");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAssetInventoryRoutes = () => {
  const http = (0, _kibana.useKibana)().services.http;
  return (0, _react.useMemo)(() => {
    const postEnableAssetInventory = async () => {
      return http.fetch(_constants.ASSET_INVENTORY_ENABLE_API_PATH, {
        method: 'POST',
        version: _constants2.API_VERSIONS.public.v1,
        body: JSON.stringify({})
      });
    };
    const getAssetInventoryStatus = async () => {
      return http.fetch(_constants.ASSET_INVENTORY_STATUS_API_PATH, {
        method: 'GET',
        version: _constants2.API_VERSIONS.public.v1,
        query: {}
      });
    };
    const postInstallAssetInventoryDataView = async () => {
      return http.fetch(_constants.ASSET_INVENTORY_INSTALL_DATA_VIEW_API_PATH, {
        method: 'POST',
        version: _constants2.API_VERSIONS.public.v1
      });
    };
    return {
      getAssetInventoryStatus,
      postEnableAssetInventory,
      postInstallAssetInventoryDataView
    };
  }, [http]);
};
exports.useAssetInventoryRoutes = useAssetInventoryRoutes;