"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewContext = exports.DataViewContext = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataViewContext = exports.DataViewContext = /*#__PURE__*/(0, _react.createContext)(undefined);

/**
 * Retrieve context's properties
 */
const useDataViewContext = () => {
  const contextValue = (0, _react.useContext)(DataViewContext);
  if (!contextValue) {
    throw new Error('useDataViewContext can only be used within DataViewContext provider');
  }
  return contextValue;
};
exports.useDataViewContext = useDataViewContext;