"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopValuesPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _top_n = require("../../../common/components/top_n");
var _sourcerer_paths = require("../../../sourcerer/containers/sourcerer_paths");
var _containers = require("../../../sourcerer/containers");
var _kibana = require("../../../common/lib/kibana");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _use_browser_fields = require("../../../data_view_manager/hooks/use_browser_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/app/components/top_values_popover/top_values_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TopValuesPopover = exports.TopValuesPopover = /*#__PURE__*/_react.default.memo(() => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const sourcererScope = (0, _sourcerer_paths.getScopeFromPath)(pathname);
  const {
    browserFields: oldBrowserFields,
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)(sourcererScope);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(sourcererScope);
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(sourcererScope);
  const browserFields = newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields;
  const {
    services: {
      topValuesPopover
    }
  } = (0, _kibana.useKibana)();
  const data = (0, _useObservable.default)(topValuesPopover.getObservable());
  const onClose = (0, _react.useCallback)(() => {
    topValuesPopover.closePopover();
  }, [topValuesPopover]);
  if (!data || !data.nodeRef) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    isOpen: true,
    button: data.nodeRef,
    closePopover: onClose,
    anchorPosition: 'downCenter',
    hasArrow: false,
    repositionOnScroll: true,
    ownFocus: true,
    attachToAnchor: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_top_n.StatefulTopN, {
    field: data.fieldName,
    scopeId: data.scopeId,
    toggleTopN: onClose,
    dataView: experimentalDataView,
    dataViewSpec: oldSourcererDataView,
    browserFields: browserFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }));
});
TopValuesPopover.displayName = 'TopValuesPopover';