"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesSubFeaturesMapV1 = exports.getCasesBaseKibanaSubFeatureIdsV1 = void 0;
var _product_features_keys = require("../../product_features_keys");
var _constants = require("../../constants");
var _utils = require("../../utils");
var _kibana_sub_features = require("../kibana_sub_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Sub-features that will always be available for Security Cases
 * regardless of the product type.
 */
const getCasesBaseKibanaSubFeatureIdsV1 = () => [_product_features_keys.CasesSubFeatureId.deleteCases, _product_features_keys.CasesSubFeatureId.casesSettings];

/**
 * Defines all the Security Solution Cases subFeatures available.
 * The order of the subFeatures is the order they will be displayed
 */
exports.getCasesBaseKibanaSubFeatureIdsV1 = getCasesBaseKibanaSubFeatureIdsV1;
const getCasesSubFeaturesMapV1 = params => {
  const subFeaturesMap = new Map([[_product_features_keys.CasesSubFeatureId.deleteCases, (0, _kibana_sub_features.getDeleteCasesSubFeature)(params)], [_product_features_keys.CasesSubFeatureId.casesSettings, (0, _kibana_sub_features.getCasesSettingsCasesSubFeature)(params)]]);
  return (0, _utils.addAllSubFeatureReplacements)(subFeaturesMap, [{
    feature: _constants.CASES_FEATURE_ID_V3
  }]);
};
exports.getCasesSubFeaturesMapV1 = getCasesSubFeaturesMapV1;