"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assistantProductFeaturesConfig = void 0;
var _product_features_keys = require("../product_features_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assistantProductFeaturesConfig = exports.assistantProductFeaturesConfig = {
  [_product_features_keys.ProductFeatureAssistantKey.assistant]: {
    privileges: {
      all: {
        ui: ['ai-assistant']
      }
    },
    subFeatureIds: [_product_features_keys.AssistantSubFeatureId.updateAnonymization, _product_features_keys.AssistantSubFeatureId.manageGlobalKnowledgeBase]
  }
};