"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rolesManagementApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _breadcrumb = require("../../components/breadcrumb");
var _readonly_badge = require("../badges/readonly_badge");
var _url_utils = require("../url_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/roles_management_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const rolesManagementApp = exports.rolesManagementApp = Object.freeze({
  id: 'roles',
  create({
    license,
    getStartServices,
    buildFlavor
  }) {
    const title = buildFlavor === 'serverless' ? _i18n.i18n.translate('xpack.security.management.rolesTitleServerless', {
      defaultMessage: 'Custom Roles'
    }) : _i18n.i18n.translate('xpack.security.management.rolesTitle', {
      defaultMessage: 'Roles'
    });
    return {
      id: this.id,
      order: 20,
      title,
      async mount({
        element,
        setBreadcrumbs,
        history
      }) {
        const [[startServices, {
          dataViews,
          features,
          spaces,
          cloud
        }], {
          RolesGridPage
        }, {
          EditRolePage
        }, {
          RolesAPIClient
        }, {
          IndicesAPIClient
        }, {
          PrivilegesAPIClient
        }, {
          UserAPIClient
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./roles_grid'))), Promise.resolve().then(() => _interopRequireWildcard(require('./edit_role'))), Promise.resolve().then(() => _interopRequireWildcard(require('./roles_api_client'))), Promise.resolve().then(() => _interopRequireWildcard(require('./indices_api_client'))), Promise.resolve().then(() => _interopRequireWildcard(require('./privileges_api_client'))), Promise.resolve().then(() => _interopRequireWildcard(require('../users')))]);
        const {
          application,
          http,
          chrome
        } = startServices;
        chrome.docTitle.change(title);
        const rolesAPIClient = new RolesAPIClient(http);
        const EditRolePageWithBreadcrumbs = ({
          action
        }) => {
          const {
            roleName
          } = (0, _reactRouterDom.useParams)();

          // Additional decoding is a workaround for a bug in react-router's version of the `history` module.
          // See https://github.com/elastic/kibana/issues/82440
          const decodedRoleName = roleName ? (0, _url_utils.tryDecodeURIComponent)(roleName) : undefined;
          const breadcrumbObj = action === 'edit' && roleName && decodedRoleName ? {
            text: decodedRoleName,
            href: `/edit/${encodeURIComponent(roleName)}`
          } : {
            text: _i18n.i18n.translate('xpack.security.roles.createBreadcrumb', {
              defaultMessage: 'Create'
            })
          };
          const spacesApiUi = spaces === null || spaces === void 0 ? void 0 : spaces.ui;
          return /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
            text: breadcrumbObj.text,
            href: breadcrumbObj.href,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 95,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(EditRolePage, (0, _extends2.default)({
            action: action,
            roleName: decodedRoleName,
            rolesAPIClient: rolesAPIClient,
            userAPIClient: new UserAPIClient(http),
            indicesAPIClient: new IndicesAPIClient(http),
            privilegesAPIClient: new PrivilegesAPIClient(http),
            getFeatures: features.getFeatures,
            license: license,
            uiCapabilities: application.capabilities,
            dataViews: dataViews,
            history: history,
            spacesApiUi: spacesApiUi,
            buildFlavor: buildFlavor,
            cloudOrgUrl: cloud === null || cloud === void 0 ? void 0 : cloud.organizationUrl
          }, startServices, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 96,
              columnNumber: 15
            }
          })));
        };
        (0, _reactDom.render)(startServices.rendering.addContext(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
          services: startServices,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
          history: history,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 120,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_readonly_badge.ReadonlyBadge, {
          featureId: "roles",
          tooltip: _i18n.i18n.translate('xpack.security.management.roles.readonlyTooltip', {
            defaultMessage: 'Unable to create or edit roles'
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 17
          }
        }), /*#__PURE__*/_react.default.createElement(_breadcrumb.BreadcrumbsProvider, {
          onChange: (0, _breadcrumb.createBreadcrumbsChangeHandler)(chrome, setBreadcrumbs),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 127,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
          text: title,
          href: "/",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 130,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: ['/', ''],
          exact: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 131,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(RolesGridPage, (0, _extends2.default)({
          rolesAPIClient: rolesAPIClient,
          history: history,
          readOnly: !startServices.application.capabilities.roles.save,
          buildFlavor: buildFlavor,
          cloudOrgUrl: cloud === null || cloud === void 0 ? void 0 : cloud.organizationUrl
        }, startServices, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 23
          }
        }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/edit/:roleName?",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 141,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(EditRolePageWithBreadcrumbs, {
          action: "edit",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 142,
            columnNumber: 23
          }
        })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/clone/:roleName",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 144,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(EditRolePageWithBreadcrumbs, {
          action: "clone",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 145,
            columnNumber: 23
          }
        }))))))), element);
        return () => {
          (0, _reactDom.unmountComponentAtNode)(element);
        };
      }
    };
  }
});