"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeSelector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _securityUiComponents = require("@kbn/security-ui-components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/kibana/simple_privilege_section/privilege_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class PrivilegeSelector extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {});
    (0, _defineProperty2.default)(this, "onChange", e => {
      this.props.onChange(e.target.value);
    });
  }
  render() {
    const {
      availablePrivileges,
      value,
      disabled,
      allowNone,
      compressed
    } = this.props;
    const options = [];
    if (allowNone) {
      options.push({
        value: _securityUiComponents.constants.NO_PRIVILEGE_VALUE,
        text: 'none'
      });
    }
    options.push(...availablePrivileges.map(p => ({
      value: p,
      text: p
    })));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": this.props['data-test-subj'],
      options: options,
      hasNoInitialSelection: !allowNone && !value,
      value: value || undefined,
      onChange: this.onChange,
      disabled: disabled,
      compressed: compressed,
      "aria-label": _i18n.i18n.translate('xpack.security.privilegeSelector.select.ariaLabel', {
        defaultMessage: 'Privilege'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    });
  }
}
exports.PrivilegeSelector = PrivilegeSelector;