"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeSummaryExpandedRow = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/kibana/privilege_summary/privilege_summary_expanded_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PrivilegeSummaryExpandedRow = props => {
  const allSpacesEffectivePrivileges = (0, _react.useMemo)(() => props.effectiveFeaturePrivileges.find(([spaces]) => spaces.includes(_constants.ALL_SPACES_ID)), [props.effectiveFeaturePrivileges]);
  const renderIndependentPrivilegeGroup = (0, _react.useCallback)((effectiveSubFeaturePrivileges, privilegeGroup, index) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }, privilegeGroup.privileges.map(privilege => {
      const isGranted = effectiveSubFeaturePrivileges.includes(privilege.id);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        "data-test-subj": "independentPrivilege",
        key: privilege.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: isGranted ? 'check' : 'cross',
        color: isGranted ? 'primary' : 'danger',
        content: isGranted ? _i18n.i18n.translate('xpack.security.management.editRole.privilegeSummary.privilegeGrantedIconTip', {
          defaultMessage: 'Privilege is granted'
        }) : _i18n.i18n.translate('xpack.security.management.editRole.privilegeSummary.privilegeNotGrantedIconTip', {
          defaultMessage: 'Privilege is not granted'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        "data-test-subj": "privilegeName",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 19
        }
      }, privilege.name)));
    }));
  }, []);
  const renderMutuallyExclusivePrivilegeGroup = (0, _react.useCallback)((effectiveSubFeaturePrivileges, privilegeGroup, index, isDisabledDueToSpaceSelection) => {
    var _privilegeGroup$privi;
    const firstSelectedPrivilege = !isDisabledDueToSpaceSelection ? (_privilegeGroup$privi = privilegeGroup.privileges.find(p => effectiveSubFeaturePrivileges.includes(p.id))) === null || _privilegeGroup$privi === void 0 ? void 0 : _privilegeGroup$privi.name : null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      key: index,
      "data-test-subj": "mutexPrivilege",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: firstSelectedPrivilege ? 'check' : 'cross',
      color: firstSelectedPrivilege ? 'primary' : 'danger',
      content: firstSelectedPrivilege ? 'Privilege is granted' : 'Privilege is not granted',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "privilegeName",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    }, firstSelectedPrivilege !== null && firstSelectedPrivilege !== void 0 ? firstSelectedPrivilege : 'None')));
  }, []);
  const renderPrivilegeGroup = (0, _react.useCallback)((effectiveSubFeaturePrivileges, {
    requireAllSpaces,
    spaces
  }) => {
    return (privilegeGroup, index) => {
      const isDisabledDueToSpaceSelection = requireAllSpaces && !spaces.includes(_constants.ALL_SPACES_ID);
      switch (privilegeGroup.groupType) {
        case 'independent':
          return renderIndependentPrivilegeGroup(effectiveSubFeaturePrivileges, privilegeGroup, index);
        case 'mutually_exclusive':
          return renderMutuallyExclusivePrivilegeGroup(effectiveSubFeaturePrivileges, privilegeGroup, index, isDisabledDueToSpaceSelection);
        default:
          throw new Error(`Unsupported privilege group type: ${privilegeGroup.groupType}`);
      }
    };
  }, [renderIndependentPrivilegeGroup, renderMutuallyExclusivePrivilegeGroup]);
  const getEffectiveFeaturePrivileges = (0, _react.useCallback)(subFeature => {
    return props.effectiveFeaturePrivileges.map((entry, index) => {
      const [spaces, privs] = subFeature.requireAllSpaces && allSpacesEffectivePrivileges ? allSpacesEffectivePrivileges : entry;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: index,
        "data-test-subj": `entry-${index}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 11
        }
      }, subFeature.getPrivilegeGroups().map(renderPrivilegeGroup(privs.subFeature, {
        requireAllSpaces: subFeature.requireAllSpaces,
        spaces
      })));
    });
  }, [props.effectiveFeaturePrivileges, allSpacesEffectivePrivileges, renderPrivilegeGroup]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, props.feature.getSubFeatures().map(subFeature => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: subFeature.name,
      "data-test-subj": "subFeatureEntry",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "subFeatureName",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 17
      }
    }, subFeature.name)), getEffectiveFeaturePrivileges(subFeature)));
  }));
};
exports.PrivilegeSummaryExpandedRow = PrivilegeSummaryExpandedRow;