"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterPrivileges = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _model = require("../../../../../../common/model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/es/cluster_privileges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ClusterPrivileges extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "buildComboBox", items => {
      const {
        role,
        editable
      } = this.props;
      const options = items.map(i => ({
        label: i
      }));
      const selectedOptions = (role.elasticsearch.cluster || []).map(k => ({
        label: k
      }));
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: 'clusterPrivs',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.clusterPrivilegeForm.clusterPrivilegesAriaLabel', {
          defaultMessage: 'Cluster privileges'
        }),
        "data-test-subj": 'cluster-privileges-combobox',
        options: options,
        selectedOptions: selectedOptions,
        onChange: this.onClusterPrivilegesChange,
        onCreateOption: this.onCreateCustomPrivilege,
        isDisabled: (0, _model.isRoleReadOnly)(role) || !editable,
        placeholder: _i18n.i18n.translate('xpack.security.management.editRole.clusterPrivileges.placeholder', {
          defaultMessage: 'Add a privilege…'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "onClusterPrivilegesChange", selectedPrivileges => {
      this.props.onChange(selectedPrivileges.map(priv => priv.label));
    });
    (0, _defineProperty2.default)(this, "onCreateCustomPrivilege", customPrivilege => {
      this.props.onChange([...this.props.role.elasticsearch.cluster, customPrivilege]);
    });
    (0, _defineProperty2.default)(this, "getAvailableClusterPrivileges", () => {
      const availableClusterPrivileges = [...this.props.builtinClusterPrivileges, ...this.props.role.elasticsearch.cluster];
      return _lodash.default.uniq(availableClusterPrivileges);
    });
  }
  render() {
    const availableClusterPrivileges = this.getAvailableClusterPrivileges();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 12
      }
    }, this.buildComboBox(availableClusterPrivileges));
  }
}
exports.ClusterPrivileges = ClusterPrivileges;
(0, _defineProperty2.default)(ClusterPrivileges, "defaultProps", {
  editable: true
});