"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapsiblePanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/collapsible_panel/collapsible_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CollapsiblePanelTitle = ({
  iconType,
  title,
  collapsed,
  toggleCollapsed
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'baseline',
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, iconType && /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: iconType,
    size: "xl",
    css: (0, _react.css)`
                    margin-right: ${euiTheme.size.s};
                    vertical-align: text-bottom;
                  `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 17
    }
  }), ' '), title))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    "data-test-subj": "showHidePrivilege",
    onClick: toggleCollapsed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, collapsed ? /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRole.collapsiblePanel.showLinkText",
    defaultMessage: "show",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRole.collapsiblePanel.hideLinkText",
    defaultMessage: "hide",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }))));
};
class CollapsiblePanel extends _react2.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "state", {
      collapsed: false
    });
    (0, _defineProperty2.default)(this, "getTitle", () => {
      return /*#__PURE__*/_react2.default.createElement(CollapsiblePanelTitle, {
        iconType: this.props.iconType,
        title: this.props.title,
        collapsed: this.state.collapsed,
        toggleCollapsed: this.toggleCollapsed,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 7
        }
      });
    });
    (0, _defineProperty2.default)(this, "getForm", () => {
      if (this.state.collapsed) {
        return null;
      }
      return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 9
        }
      }), this.props.children);
    });
    (0, _defineProperty2.default)(this, "toggleCollapsed", () => {
      this.setState({
        collapsed: !this.state.collapsed
      });
    });
    this.state = {
      collapsed: props.initiallyCollapsed || false
    };
  }
  render() {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 7
      }
    }, this.getTitle(), this.getForm());
  }
}
exports.CollapsiblePanel = CollapsiblePanel;