"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteProvider = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/components/delete_provider/delete_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteProvider = ({
  roleMappingsAPI,
  children,
  notifications
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [roleMappings, setRoleMappings] = (0, _react.useState)([]);
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const [isDeleteInProgress, setIsDeleteInProgress] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const onCancelCallback = (0, _react.useRef)(null);
  const deleteRoleMappingsPrompt = (roleMappingsToDelete, onSuccess = () => undefined, onCancel = () => undefined) => {
    if (!roleMappingsToDelete || !roleMappingsToDelete.length) {
      throw new Error('No Role Mappings specified for delete');
    }
    setIsModalOpen(true);
    setRoleMappings(roleMappingsToDelete);
    onSuccessCallback.current = onSuccess;
    onCancelCallback.current = onCancel;
  };
  const closeModal = () => {
    setIsModalOpen(false);
    setRoleMappings([]);
  };
  const handleCancelModel = () => {
    closeModal();
    if (onCancelCallback.current) {
      onCancelCallback.current();
    }
  };
  const deleteRoleMappings = async () => {
    let result;
    setIsDeleteInProgress(true);
    try {
      result = await roleMappingsAPI.deleteRoleMappings(roleMappings.map(rm => rm.name));
    } catch (e) {
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.security.management.roleMappings.deleteRoleMapping.unknownError', {
          defaultMessage: 'Error deleting role mappings'
        })
      });
      setIsDeleteInProgress(false);
      return;
    }
    setIsDeleteInProgress(false);
    closeModal();
    const successfulDeletes = result.filter(res => res.success);
    const erroredDeletes = result.filter(res => !res.success);

    // Surface success notifications
    if (successfulDeletes.length > 0) {
      const hasMultipleSuccesses = successfulDeletes.length > 1;
      const successMessage = hasMultipleSuccesses ? _i18n.i18n.translate('xpack.security.management.roleMappings.deleteRoleMapping.successMultipleNotificationTitle', {
        defaultMessage: 'Deleted {count} role mappings',
        values: {
          count: successfulDeletes.length
        }
      }) : _i18n.i18n.translate('xpack.security.management.roleMappings.deleteRoleMapping.successSingleNotificationTitle', {
        defaultMessage: "Deleted role mapping ''{name}''",
        values: {
          name: successfulDeletes[0].name
        }
      });
      notifications.toasts.addSuccess({
        title: successMessage,
        'data-test-subj': 'deletedRoleMappingSuccessToast'
      });
      if (onSuccessCallback.current) {
        onSuccessCallback.current(successfulDeletes.map(({
          name
        }) => name));
      }
    }

    // Surface error notifications
    if (erroredDeletes.length > 0) {
      const hasMultipleErrors = erroredDeletes.length > 1;
      const errorMessage = hasMultipleErrors ? _i18n.i18n.translate('xpack.security.management.roleMappings.deleteRoleMapping.errorMultipleNotificationTitle', {
        defaultMessage: 'Error deleting {count} role mappings',
        values: {
          count: erroredDeletes.length
        }
      }) : _i18n.i18n.translate('xpack.security.management.roleMappings.deleteRoleMapping.errorSingleNotificationTitle', {
        defaultMessage: "Error deleting role mapping ''{name}''",
        values: {
          name: erroredDeletes[0].name
        }
      });
      notifications.toasts.addDanger(errorMessage);
    }
  };
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    const isSingle = roleMappings.length === 1;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      titleProps: {
        id: confirmModalTitleId
      },
      title: isSingle ? _i18n.i18n.translate('xpack.security.management.roleMappings.deleteRoleMapping.confirmModal.deleteSingleTitle', {
        defaultMessage: "Delete role mapping ''{name}''?",
        values: {
          name: roleMappings[0].name
        }
      }) : _i18n.i18n.translate('xpack.security.management.roleMappings.deleteRoleMapping.confirmModal.deleteMultipleTitle', {
        defaultMessage: 'Delete {count} role mappings?',
        values: {
          count: roleMappings.length
        }
      }),
      onCancel: handleCancelModel,
      onConfirm: deleteRoleMappings,
      cancelButtonText: _i18n.i18n.translate('xpack.security.management.roleMappings.deleteRoleMapping.confirmModal.cancelButtonLabel', {
        defaultMessage: 'Cancel'
      }),
      confirmButtonText: _i18n.i18n.translate('xpack.security.management.roleMappings.deleteRoleMapping.confirmModal.confirmButtonLabel', {
        defaultMessage: 'Delete {count, plural, one {role mapping} other {role mappings}}',
        values: {
          count: roleMappings.length
        }
      }),
      confirmButtonDisabled: isDeleteInProgress,
      buttonColor: "danger",
      "data-test-subj": "deleteRoleMappingConfirmationModal",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 7
      }
    }, !isSingle ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.security.management.roleMappings.deleteRoleMapping.confirmModal.deleteMultipleListDescription', {
      defaultMessage: 'You are about to delete these role mappings:'
    })), /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 13
      }
    }, roleMappings.map(({
      name
    }) => /*#__PURE__*/_react.default.createElement("li", {
      key: name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 17
      }
    }, name)))) : null);
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 5
    }
  }, children(deleteRoleMappingsPrompt), renderModal());
};
exports.DeleteProvider = DeleteProvider;