"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardDetailsTreeNode = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
var _use_highlight_tree_node = require("../use_highlight_tree_node");
var _lib = require("../../../lib");
var _percentage_badge = require("../../percentage_badge");
var _shard_details_tree_node = require("./shard_details_tree_node.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/searchprofiler/public/application/components/profile_tree/shard_details/shard_details_tree_node.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TAB_WIDTH_PX = 32;
const limitString = (string, limit) => `${string.slice(0, limit)}${string.length > limit ? '...' : ''}`;

/**
 * This component recursively renders a tree
 */
const ShardDetailsTreeNode = ({
  operation,
  index,
  shard
}) => {
  const [childrenVisible, setChildrenVisible] = (0, _react.useState)((0, _utils.hasVisibleChild)(operation));
  const {
    highlight,
    isHighlighted,
    id
  } = (0, _use_highlight_tree_node.useHighlightTreeNode)();
  const styles = (0, _shard_details_tree_node.useStyles)();
  const renderTimeRow = op => /*#__PURE__*/_react.default.createElement("div", {
    css: styles.tvRow,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.cell,
    className: "euiTextAlign--left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, op.hasChildren ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    css: styles.shardDetails,
    disabled: !op.hasChildren,
    onClick: () => setChildrenVisible(!childrenVisible),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: childrenVisible ? 'arrowDown' : 'arrowRight',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 13
    }
  }), ' ' + op.query_type) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "dot",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }), ' ' + op.query_type)), /*#__PURE__*/_react.default.createElement("div", {
    css: [styles.cell, styles.time],
    className: "euiTextAlign--center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: styles.badge,
    color: op.absoluteColor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, (0, _lib.msToPretty)(op.selfTime || 0, 1))), /*#__PURE__*/_react.default.createElement("div", {
    css: [styles.cell, styles.totalTime],
    className: "euiTextAlign--center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: styles.badge,
    color: op.absoluteColor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, (0, _lib.msToPretty)(op.time, 1))), /*#__PURE__*/_react.default.createElement("div", {
    css: [styles.cell, styles.percentage],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_percentage_badge.PercentageBadge, {
    timePercentage: op.timePercentage,
    label: op.timePercentage + '%',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    key: id,
    css: isHighlighted() ? styles.tvRowLast : undefined,
    style: {
      paddingLeft: operation.depth * TAB_WIDTH_PX + 'px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, renderTimeRow(operation), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.tvRow,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: styles.detail,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, limitString(operation.lucene || '', 120)), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    type: "button",
    "data-test-subj": "viewShardDetails",
    onClick: () => highlight({
      indexName: index.name,
      operation,
      shard
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.searchProfiler.profileTree.body.viewDetailsLabel', {
    defaultMessage: 'View details'
  }))))), childrenVisible && operation.hasChildren && operation.children.map((childOp, idx) => /*#__PURE__*/_react.default.createElement(ShardDetailsTreeNode, {
    key: idx,
    operation: childOp,
    index: index,
    shard: shard,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  })));
};
exports.ShardDetailsTreeNode = ShardDetailsTreeNode;