"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentageBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/searchprofiler/public/application/components/percentage_badge/percentage_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = valueType => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const color = valueType === 'percent' ? euiTheme.colors.backgroundLightPrimary : euiTheme.colors.backgroundLightDanger;
  return {
    percentBadge: (0, _react2.css)`
      border: none;
      display: block;
      background-image: linear-gradient(
        to right,
        ${color} 0%,
        ${color} var(--prfDevToolProgressPercentage, auto),
        ${euiTheme.colors.backgroundBaseSubdued} var(--prfDevToolProgressPercentage, auto),
        ${euiTheme.colors.backgroundBaseSubdued} 100%
      );
      width: ${valueType === 'percent' ? 'var(--prfDevToolBadgeSize)' : 'var(--prfDevToolBadgeSizeExtended)'};
    `,
    progressTextIE: (0, _react2.css)`
      display: none;
    `
  };
};

/**
 * This component has IE specific provision for rendering the percentage portion of the badge correctly.
 *
 * This component uses CSS vars injected against the DOM element and resolves this in CSS to calculate
 * how far the percent bar should be drawn.
 */
const PercentageBadge = ({
  timePercentage,
  label,
  valueType = 'percent'
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = useStyles(valueType);

  // Calculate badge sizes once
  const badgeSize = (0, _react.useMemo)(() => euiTheme.base * 5.5, [euiTheme.base]);
  const extendedBadgeSize = (0, _react.useMemo)(() => badgeSize * 3 - parseFloat(euiTheme.size.xs) * 0.7, [badgeSize, euiTheme.size.xs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: styles.percentBadge,
    className: "euiTextAlign--center",
    color: euiTheme.colors.backgroundBaseSubdued,
    style: {
      '--prfDevToolProgressPercentage': timePercentage + '%',
      '--prfDevToolBadgeSize': `${badgeSize}px`,
      '--prfDevToolBadgeSizeExtended': `${extendedBadgeSize}px`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: styles.progressTextIE,
    style: {
      width: timePercentage + '%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, label));
};
exports.PercentageBadge = PercentageBadge;