"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQueryRuleFlyoutState = exports.createEmptyRuleset = void 0;
var _react = require("react");
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _constants = require("../../../analytics/constants");
var _use_fetch_index_names = require("../../../hooks/use_fetch_index_names");
var _query_rules_utils = require("../../../utils/query_rules_utils");
var _use_usage_tracker = require("../../../hooks/use_usage_tracker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEmptyRuleset = rulesetId => ({
  ruleset_id: rulesetId,
  rules: []
});
exports.createEmptyRuleset = createEmptyRuleset;
const useQueryRuleFlyoutState = ({
  createMode,
  rulesetId,
  ruleId,
  rules,
  setIsFormDirty,
  onSave
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    control,
    getValues,
    reset,
    setValue,
    formState,
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const {
    fields: criteria,
    remove,
    replace,
    update,
    append
  } = (0, _reactHookForm.useFieldArray)({
    control,
    name: 'criteria'
  });
  const {
    fields: actionFields,
    remove: removeAction,
    replace: replaceAction,
    append: appendAction
  } = (0, _reactHookForm.useFieldArray)({
    control,
    name: 'actions.docs'
  });
  const isAlways = (0, _reactHookForm.useWatch)({
    control,
    name: 'isAlways'
  });
  const pinType = (0, _reactHookForm.useWatch)({
    control,
    name: 'type'
  });
  const actionIdsFields = (0, _reactHookForm.useWatch)({
    control,
    name: 'actions.ids'
  });
  (0, _react.useEffect)(() => {
    trigger('actions.ids');
  }, [actionIdsFields, trigger]);
  (0, _react.useEffect)(() => {
    trigger('actions.docs');
  }, [actionFields, trigger]);
  (0, _react.useEffect)(() => {
    trigger('criteria');
  }, [criteria, trigger]);
  const {
    data: indexNames
  } = (0, _use_fetch_index_names.useFetchIndexNames)('');
  const ruleFromRuleset = rules.find(rule => rule.rule_id === ruleId);
  const isDocRule = Boolean(!actionIdsFields || actionFields.length > 0 || !!((actionIdsFields === null || actionIdsFields === void 0 ? void 0 : actionIdsFields.length) === 0));
  const isIdRule = Boolean(!isDocRule && actionFields.length === 0 && (actionIdsFields === null || actionIdsFields === void 0 ? void 0 : actionIdsFields.length));
  (0, _react.useEffect)(() => {
    if (ruleFromRuleset) {
      var _ref;
      reset({
        ...getValues(),
        criteria: ruleFromRuleset.criteria,
        type: ruleFromRuleset.type,
        actions: ruleFromRuleset.actions,
        mode: 'edit',
        isAlways: (_ref = (ruleFromRuleset === null || ruleFromRuleset === void 0 ? void 0 : ruleFromRuleset.criteria) && (0, _query_rules_utils.isCriteriaAlways)(ruleFromRuleset === null || ruleFromRuleset === void 0 ? void 0 : ruleFromRuleset.criteria)) !== null && _ref !== void 0 ? _ref : false,
        ruleId
      });
    }
  }, [ruleFromRuleset, reset, getValues, rulesetId, ruleId]);
  (0, _react.useEffect)(() => {
    if (createMode) {
      reset({
        criteria: [{
          type: 'exact',
          metadata: '',
          values: []
        }],
        type: 'pinned',
        actions: {
          docs: [{
            _id: '',
            _index: ''
          }],
          ids: []
        },
        mode: 'create',
        isAlways: false,
        ruleId
      });
    }
  }, [createMode, reset, ruleId]);
  const handleAddCriteria = () => {
    append({
      type: 'exact',
      metadata: '',
      values: []
    });
  };
  const appendNewAction = () => {
    if (isIdRule) {
      setValue('actions.ids', [...(getValues('actions.ids') || []), '']);
    } else {
      appendAction({
        _id: '',
        _index: ''
      });
    }
  };
  const handleSave = () => {
    setIsFormDirty === null || setIsFormDirty === void 0 ? void 0 : setIsFormDirty(true);
    const index = rules.findIndex(rule => rule.rule_id === ruleId);
    if (index !== -1) {
      if (isAlways) {
        replace([{
          type: 'always'
        }]);
      }
      let actions = {};
      if (isDocRule) {
        actions = {
          docs: actionFields.map(doc => ({
            _id: doc._id,
            _index: doc._index
          }))
        };
      } else if (isIdRule) {
        actions = {
          ids: actionIdsFields
        };
      }
      const updatedRule = {
        rule_id: ruleId,
        criteria: isAlways ? [{
          type: 'always'
        }] : criteria.map(c => {
          const normalizedCriteria = {
            values: c.values,
            metadata: c.metadata,
            type: c.type
          };
          return normalizedCriteria;
        }),
        type: getValues('type'),
        actions
      };
      onSave(updatedRule);
    } else {
      onSave({
        rule_id: ruleId,
        criteria: isAlways ? [{
          type: 'always'
        }] : criteria.map(c => {
          const normalizedCriteria = {
            values: c.values,
            metadata: c.metadata,
            type: c.type
          };
          return normalizedCriteria;
        }),
        type: getValues('type'),
        actions: isDocRule ? {
          docs: actionFields.map(doc => ({
            _id: doc._id,
            _index: doc._index
          }))
        } : {
          ids: actionIdsFields
        }
      });
    }
  };
  const CRITERIA_CALLOUT_STORAGE_KEY = 'queryRules.criteriaCalloutState';
  const [criteriaCalloutActive, setCriteriaCalloutActive] = (0, _react.useState)(() => {
    try {
      const savedState = localStorage.getItem(CRITERIA_CALLOUT_STORAGE_KEY);
      if (savedState === null) {
        localStorage.setItem(CRITERIA_CALLOUT_STORAGE_KEY, 'true');
        return true;
      }
      return savedState !== 'false';
    } catch (e) {
      return true;
    }
  });
  (0, _react.useEffect)(() => {
    try {
      localStorage.setItem(CRITERIA_CALLOUT_STORAGE_KEY, criteriaCalloutActive ? 'true' : 'false');
    } catch (e) {
      // If localStorage is not available, we can ignore the error
    }
  }, [criteriaCalloutActive]);
  const shouldShowCriteriaCallout = criteriaCalloutActive && !isAlways;
  const dragEndHandle = ({
    source,
    destination
  }) => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.ruleFlyoutDocumentsReordered);
    if (source && destination && (ruleFromRuleset || createMode)) {
      if (isDocRule) {
        const newActions = (0, _eui.euiDragDropReorder)(actionFields, source.index, destination.index);
        replaceAction(newActions);
      } else if (isIdRule && actionIdsFields) {
        const newActions = (0, _eui.euiDragDropReorder)(actionIdsFields, source.index, destination.index);
        setValue('actions.ids', [...newActions]);
      }
    }
  };
  const onDeleteDocument = index => {
    if (createMode || !isIdRule) {
      removeAction(index);
    } else {
      if (actionIdsFields) {
        const updatedActions = actionIdsFields.filter((_, i) => i !== index);
        setValue('actions.ids', updatedActions);
      }
    }
  };
  const onIndexSelectorChange = (index, indexName) => {
    const updatedActions = actionFields.map((action, i) => i === index ? {
      ...action,
      _index: indexName
    } : action);
    replaceAction(updatedActions);
  };
  const onIdSelectorChange = (index, id) => {
    if (isIdRule && actionIdsFields) {
      const updatedActions = actionIdsFields.map((value, i) => i === index ? id : value);
      setValue('actions.ids', updatedActions);
    } else {
      if (isDocRule || createMode) {
        const updatedActions = actionFields.map((action, i) => i === index ? {
          ...action,
          _id: id
        } : action);
        replaceAction(updatedActions);
      }
    }
  };
  const documentCount = actionFields.length || (actionIdsFields === null || actionIdsFields === void 0 ? void 0 : actionIdsFields.length) || 0;
  const shouldShowMetadataEditor = (createMode || !!ruleFromRuleset) && !isAlways;
  const criteriaCount = criteria.length;
  return {
    actionFields,
    actionIdsFields,
    appendAction: appendNewAction,
    control,
    criteria,
    criteriaCount,
    documentCount,
    dragEndHandle,
    formState,
    getValues,
    handleAddCriteria,
    handleSave,
    indexNames,
    isAlways,
    isDocRule,
    isIdRule,
    isFlyoutDirty: formState.isDirty,
    onDeleteDocument,
    onIdSelectorChange,
    onIndexSelectorChange,
    pinType,
    remove,
    setCriteriaCalloutActive,
    shouldShowCriteriaCallout,
    shouldShowMetadataEditor,
    update
  };
};
exports.useQueryRuleFlyoutState = useQueryRuleFlyoutState;