"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleListItemContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_usage_tracker = require("../../../hooks/use_usage_tracker");
var _query_rule_draggable_item_action_type_badge = require("./query_rule_draggable_item_action_type_badge");
var _query_rule_draggable_item_criteria_display = require("./query_rule_draggable_item_criteria_display");
var _delete_ruleset_rule_modal = require("./delete_ruleset_rule_modal");
var _constants = require("../../../analytics/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/query_ruleset_detail/query_rule_draggable_list/query_rule_list_item_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_VISIBLE_CRITERIA = 3;
const getVisibleCriteriaDescription = queryRule => {
  var _queryRule$criteria$v;
  if (Array.isArray(queryRule.criteria)) {
    const visibleCriteriaText = queryRule.criteria.slice(0, MAX_VISIBLE_CRITERIA).map(criteria => {
      var _criteria$values;
      const parts = [];
      if (criteria.metadata) {
        parts.push(criteria.metadata);
      }
      parts.push(criteria.type);
      if ((_criteria$values = criteria.values) !== null && _criteria$values !== void 0 && _criteria$values.length) {
        parts.push(criteria.values.join(', '));
      }
      return parts.join(' ');
    }).join('; ');
    if (queryRule.criteria.length > MAX_VISIBLE_CRITERIA) {
      const moreText = _i18n.i18n.translate('xpack.search.queryRulesetDetail.draggableList.dragHandle.moreCriteria', {
        defaultMessage: 'and {count} more',
        values: {
          count: queryRule.criteria.length - MAX_VISIBLE_CRITERIA
        }
      });
      return `${visibleCriteriaText} ${moreText}`;
    }
    return visibleCriteriaText;
  }
  const parts = [];
  if (queryRule.criteria.metadata) {
    parts.push(queryRule.criteria.metadata);
  }
  parts.push(queryRule.criteria.type);
  if ((_queryRule$criteria$v = queryRule.criteria.values) !== null && _queryRule$criteria$v !== void 0 && _queryRule$criteria$v.length) {
    parts.push(queryRule.criteria.values.join(', '));
  }
  return parts.join(' ');
};
const QueryRuleListItemContent = ({
  rules,
  queryRule,
  onEditRuleFlyoutOpen,
  deleteRule,
  order = '-',
  isDraggable = false,
  dragHandleProps,
  tourTargetRef
}) => {
  var _queryRule$actions$do, _queryRule$actions$do2, _queryRule$actions$do3, _queryRule$actions$do4;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const useTracker = (0, _use_usage_tracker.useUsageTracker)();
  const [isPopoverOpen, setIsPopoverOpen] = _react.default.useState(false);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const openPopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(true);
  }, []);
  const [ruleToDelete, setRuleToDelete] = (0, _react.useState)(null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ruleToDelete && /*#__PURE__*/_react.default.createElement(_delete_ruleset_rule_modal.DeleteRulesetRuleModal, {
    closeDeleteModal: () => setRuleToDelete(null),
    onConfirm: () => {
      if (deleteRule) {
        deleteRule(ruleToDelete);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    ref: tourTargetRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, isDraggable ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    color: "transparent",
    paddingSize: "s"
  }, dragHandleProps, {
    "aria-label": _i18n.i18n.translate('xpack.search.queryRulesetDetail.draggableList.dragHandle.aria.label', {
      defaultMessage: 'Drag handle for {actionType} rule with ID: {ruleId}. ' + 'The rule has {documentCount, plural, one {document} other {documents}} ' + 'and {criteriaCount} {criteriaCount, plural, one {criterion} other {criteria}}. ' + 'Visible criteria: {visibleCriteria}',
      values: {
        actionType: queryRule.type === 'exclude' ? 'exclude' : 'pinned',
        ruleId: queryRule.rule_id,
        documentCount: (_queryRule$actions$do = (_queryRule$actions$do2 = queryRule.actions.docs) === null || _queryRule$actions$do2 === void 0 ? void 0 : _queryRule$actions$do2.length) !== null && _queryRule$actions$do !== void 0 ? _queryRule$actions$do : 0,
        criteriaCount: Array.isArray(queryRule.criteria) ? queryRule.criteria.length : 1,
        visibleCriteria: getVisibleCriteriaDescription(queryRule)
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    css: (0, _react2.css)({
      minWidth: euiTheme.base * 2,
      minHeight: euiTheme.base * 2
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 17
    }
  }, order)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 17
    }
  }, Array.isArray(queryRule.criteria) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, queryRule.criteria.slice(0, MAX_VISIBLE_CRITERIA).map((criteria, criteriaIndex) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: criteria.type + criteriaIndex,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_query_rule_draggable_item_criteria_display.QueryRuleDraggableItemCriteriaDisplay, {
    criteria: criteria,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 29
    }
  }))), queryRule.criteria.length > 3 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.draggableList.queryRulesCriteriaMoreLabel",
    defaultMessage: "+{count} more",
    values: {
      count: queryRule.criteria.length - 3
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 29
    }
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_query_rule_draggable_item_criteria_display.QueryRuleDraggableItemCriteriaDisplay, {
    criteria: queryRule.criteria,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 23
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_query_rule_draggable_item_action_type_badge.QueryRuleDraggableListItemActionTypeBadge, {
    queryRule: queryRule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "queryRuleActionsPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": isDraggable ? _i18n.i18n.translate('xpack.search.queryRulesetDetail.draggableList.actionsButton.aria.label.draggable', {
        defaultMessage: 'Click to reach actions menu for rule {ruleId}',
        values: {
          ruleId: queryRule.rule_id
        }
      }) : _i18n.i18n.translate('xpack.search.queryRulesetDetail.draggableList.actionsButton.aria.label.searchResult', {
        defaultMessage: 'Click to reach actions menu for {actionType} rule with ID: {ruleId}. ' + 'The rule has {documentCount, plural, one {document} other {documents}} ' + 'and {criteriaCount} {criteriaCount, plural, one {criterion} other {criteria}}. ' + 'Visible criteria: {visibleCriteria}',
        values: {
          actionType: queryRule.type === 'exclude' ? 'exclude' : 'pinned',
          ruleId: queryRule.rule_id,
          documentCount: (_queryRule$actions$do3 = (_queryRule$actions$do4 = queryRule.actions.docs) === null || _queryRule$actions$do4 === void 0 ? void 0 : _queryRule$actions$do4.length) !== null && _queryRule$actions$do3 !== void 0 ? _queryRule$actions$do3 : 0,
          criteriaCount: Array.isArray(queryRule.criteria) ? queryRule.criteria.length : 1,
          visibleCriteria: getVisibleCriteriaDescription(queryRule)
        }
      }),
      "data-test-subj": "searchQueryRulesQueryRulesetDetailButton",
      iconType: "boxesHorizontal",
      color: "text",
      onClick: () => {
        openPopover();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 21
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "edit",
      icon: "pencil",
      "data-test-subj": "searchQueryRulesQueryRulesetDetailEditButton",
      onClick: () => {
        useTracker === null || useTracker === void 0 ? void 0 : useTracker.click(_constants.AnalyticsEvents.editRuleClicked);
        onEditRuleFlyoutOpen(queryRule.rule_id);
        closePopover();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.draggableList.actions.edit",
      defaultMessage: "Edit rule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 25
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      toolTipContent: rules.length === 1 ? _i18n.i18n.translate('xpack.search.queryRulesetDetail.draggableList.actions.deleteTooltip', {
        defaultMessage: 'The ruleset must contains at least 1 rule.'
      }) : undefined,
      disabled: rules.length === 1,
      key: "delete",
      icon: "trash",
      css: (0, _react2.css)`
                          color: ${rules.length === 1 ? euiTheme.colors.textDisabled : euiTheme.colors.danger};
                        `,
      "data-test-subj": "searchQueryRulesQueryRulesetDetailDeleteButton",
      onClick: () => {
        useTracker === null || useTracker === void 0 ? void 0 : useTracker.click(_constants.AnalyticsEvents.deleteRuleClicked);
        setRuleToDelete(queryRule.rule_id);
        closePopover();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.draggableList.actions.delete",
      defaultMessage: "Delete rule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 25
      }
    }))],
    className: "euiContextMenuPanel--inPopover",
    "data-test-subj": "searchQueryRulesQueryRulesetDetailContextMenu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 19
    }
  }))))))));
};
exports.QueryRuleListItemContent = QueryRuleListItemContent;