"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteRulesetModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_delete_query_rules_ruleset = require("../../hooks/use_delete_query_rules_ruleset");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/query_rules_sets/delete_ruleset_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteRulesetModal = ({
  closeDeleteModal,
  rulesetId,
  onSuccessAction
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [error, setError] = (0, _react.useState)(null);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const onSuccess = () => {
    setIsLoading(false);
    closeDeleteModal();
    if (onSuccessAction) {
      onSuccessAction();
    }
  };
  const confirmCheckboxId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'confirmCheckboxId'
  });
  const [checked, setChecked] = (0, _react.useState)(false);
  const onError = errorMessage => {
    setIsLoading(false);
    setError(errorMessage);
  };
  const {
    mutate: deleteEndpoint
  } = (0, _use_delete_query_rules_ruleset.useDeleteRuleset)(onSuccess, onError);
  const deleteOperation = () => {
    setIsLoading(true);
    deleteEndpoint({
      rulesetId
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: _i18n.i18n.translate('xpack.queryRules.deleteRulesetModal.title', {
      defaultMessage: 'Delete query ruleset?'
    }),
    onCancel: closeDeleteModal,
    onConfirm: deleteOperation,
    cancelButtonText: _i18n.i18n.translate('xpack.queryRules.deleteRulesetModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.queryRules.deleteRulesetModal.confirmButton', {
      defaultMessage: 'Delete ruleset'
    }),
    confirmButtonDisabled: checked === false,
    buttonColor: "danger",
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.queryRules.deleteRulesetModal.body', {
    defaultMessage: 'Deleting a ruleset referenced in a query will result in a broken query.  Make sure you have fixed any references to this ruleset prior to deletion.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: confirmCheckboxId,
    label: "This ruleset is safe to delete",
    "data-test-subj": "confirmDeleteRulesetCheckbox",
    checked: checked,
    onChange: e => {
      setChecked(e.target.checked);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), error && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "s",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, error));
};
exports.DeleteRulesetModal = DeleteRulesetModal;