"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaygroundRouter = void 0;
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _playground_list_page = require("./playground_list_page");
var _playground_overview = require("./playground_overview");
var _saved_playground = require("./saved_playground");
var _routes = require("./routes");
var _use_license_status = require("./hooks/use_license_status");
var _use_search_playground_feature_flag = require("./hooks/use_search_playground_feature_flag");
var _playground_unavailable_page = require("./playground_unavailable_page");
var _not_found = require("./components/not_found");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/playground_router.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PlaygroundRouter = () => {
  const {
    hasRequiredLicense
  } = (0, _use_license_status.usePlaygroundLicenseStatus)();
  const isSearchModeEnabled = (0, _use_search_playground_feature_flag.useSearchPlaygroundFeatureFlag)();
  if (!hasRequiredLicense) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      component: _playground_unavailable_page.PlaygroundUnavailable,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ROOT_PATH,
    component: _playground_list_page.PlaygroundsListPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SAVED_PLAYGROUND_PATH,
    component: _saved_playground.SavedPlaygroundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }), !isSearchModeEnabled && /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: _routes.SEARCH_PLAYGROUND_SEARCH_PATH,
    to: _routes.SEARCH_PLAYGROUND_CHAT_PATH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SEARCH_PLAYGROUND_NOT_FOUND,
    component: _not_found.PlaygroundRouteNotFound,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/:pageMode/:viewMode?`,
    component: _playground_overview.PlaygroundOverview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }));
};
exports.PlaygroundRouter = PlaygroundRouter;