"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadConnectors = exports.LoadConnectorsQuery = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("@kbn/triggers-actions-ui-plugin/public/common/constants");
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
var _playground_connectors = require("../utils/playground_connectors");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LoadConnectorsQuery = http => async () => {
  const queryResult = await (0, _constants.loadAllActions)({
    http
  });
  return (0, _playground_connectors.parsePlaygroundConnectors)(queryResult, http);
};
exports.LoadConnectorsQuery = LoadConnectorsQuery;
const useLoadConnectors = () => {
  const {
    services: {
      http,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useQuery)([_common.SearchPlaygroundQueryKeys.LoadConnectors], LoadConnectorsQuery(http), {
    retry: false,
    keepPreviousData: true,
    onError: error => {
      if (error.name !== 'AbortError') {
        var _notifications$toasts;
        notifications === null || notifications === void 0 ? void 0 : (_notifications$toasts = notifications.toasts) === null || _notifications$toasts === void 0 ? void 0 : _notifications$toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: _i18n.i18n.translate('xpack.searchPlayground.loadConnectorsError', {
            defaultMessage: 'Error loading connectors. Please check your configuration and try again.'
          })
        });
      }
    }
  });
};
exports.useLoadConnectors = useLoadConnectors;