"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncludeCitationsField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/summarization_panel/include_citations_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IncludeCitationsField = ({
  checked,
  onChange
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const handleChange = value => {
    onChange(value);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(`${_constants.AnalyticsEvents.includeCitations}_${String(value)}`);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.searchPlayground.sidebar.citationsField.label', {
      defaultMessage: 'Include citations'
    }),
    "data-test-subj": "includeCitationsToggle",
    checked: checked,
    onChange: e => handleChange(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }));
};
exports.IncludeCitationsField = IncludeCitationsField;