"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("@kbn/deeplinks-search/constants");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/setup_page/create_index_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateIndexButton = () => {
  var _chrome$navLinks$get;
  const {
    services: {
      application,
      chrome
    }
  } = (0, _use_kibana.useKibana)();
  const createIndexUrl = (_chrome$navLinks$get = chrome.navLinks.get(`${_constants.SEARCH_INDICES}:${_constants.SEARCH_INDICES_CREATE_INDEX}`)) === null || _chrome$navLinks$get === void 0 ? void 0 : _chrome$navLinks$get.url;
  const handleCreateIndexClick = (0, _react.useCallback)(event => {
    event.preventDefault();
    if (!createIndexUrl) {
      return;
    }
    application === null || application === void 0 ? void 0 : application.navigateToUrl(createIndexUrl);
  }, [application, createIndexUrl]);
  return createIndexUrl ?
  /*#__PURE__*/
  // eslint-disable-next-line @elastic/eui/href-or-on-click
  _react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    "data-test-subj": "createIndexButton",
    href: createIndexUrl,
    onClick: handleCreateIndexClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.createIndexButton",
    defaultMessage: "Create an index",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.searchPlayground.createIndexCallout', {
      defaultMessage: 'You need to create an index first'
    }),
    size: "s",
    color: "warning",
    "data-test-subj": "createIndexCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  });
};
exports.CreateIndexButton = CreateIndexButton;