"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchQueryViewer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _codeEditor = require("@kbn/code-editor");
var _monaco = require("@kbn/monaco");
var _reactHookForm = require("react-hook-form");
var _constants = require("../../analytics/constants");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _types = require("../../types");
var _styles = require("./styles");
var _user_query = require("../../utils/user_query");
var _field_error_callout = require("../field_error_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/query_mode/query_viewer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ElasticsearchQueryViewer = ({
  executeQuery,
  executeQueryDisabled,
  isLoading
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const [esQueryFirstEdit, setEsQueryFirtEdit] = (0, _react.useState)(false);
  const {
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const {
    field: {
      value: elasticsearchQuery
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.elasticsearchQuery
  });
  const {
    field: {
      value: userElasticsearchQuery,
      onChange: onChangeUserQuery
    },
    fieldState: {
      error: userElasticsearchQueryError
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.userElasticsearchQuery
  });
  const generatedEsQuery = (0, _react.useMemo)(() => (0, _user_query.formatElasticsearchQueryString)(elasticsearchQuery), [elasticsearchQuery]);
  const resetElasticsearchQuery = (0, _react.useCallback)(() => {
    onChangeUserQuery(null);
  }, [onChangeUserQuery]);
  const editorMounted = (0, _react.useCallback)(editor => {
    _monaco.monaco.languages.json.jsonDefaults.setDiagnosticsOptions({
      validate: true,
      schemas: []
    });
  }, []);
  const onEditorChange = (0, _react.useCallback)(value => {
    if (esQueryFirstEdit === false && value !== generatedEsQuery) {
      setEsQueryFirtEdit(true);
      usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.count(_constants.AnalyticsEvents.editElasticsearchQuery);
    }
    onChangeUserQuery(value === generatedEsQuery ? null : value);
    trigger(_types.PlaygroundFormFields.userElasticsearchQuery);
  }, [esQueryFirstEdit, generatedEsQuery, usageTracker, onChangeUserQuery, trigger]);
  const userElasticsearchQueryIsCustomized = userElasticsearchQuery !== null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    hasBorder: true,
    css: _styles.FullHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    css: (0, _styles.QueryViewTitlePanel)(euiTheme),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.queryViewer.title",
    defaultMessage: "Query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 19
    }
  }))), userElasticsearchQueryIsCustomized ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.userCustomized.badge",
    defaultMessage: "User-customized",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 19
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.elasticGenerated.badge",
    defaultMessage: "Elastic-generated",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 19
    }
  })))), userElasticsearchQuery !== null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconSide: "left",
    iconType: "refresh",
    "data-test-subj": "ResetElasticsearchQueryButton",
    onClick: resetElasticsearchQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.resetQuery.action",
    defaultMessage: "Reset to default",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 17
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    size: "s",
    color: "primary",
    iconSide: "left",
    iconType: "play",
    "data-test-subj": "RunElasticsearchQueryButton",
    onClick: () => executeQuery(),
    isLoading: isLoading,
    disabled: executeQueryDisabled,
    "aria-label": _i18n.i18n.translate('xpack.searchPlayground.viewQuery.runQuery.ariaLabel', {
      defaultMessage: 'Run the elasticsearch query to view results.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.runQuery.action",
    defaultMessage: "Run",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }))))), userElasticsearchQueryIsCustomized && userElasticsearchQueryError !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_field_error_callout.FieldErrorCallout, {
    error: userElasticsearchQueryError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    css: _styles.PanelFillContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    dataTestSubj: "ViewElasticsearchQueryResult",
    languageId: "json",
    onChange: onEditorChange,
    value: userElasticsearchQuery !== null && userElasticsearchQuery !== void 0 ? userElasticsearchQuery : generatedEsQuery,
    options: {
      automaticLayout: true
    },
    editorDidMount: editorMounted,
    enableFindAction: true,
    fullWidth: true,
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  })));
};
exports.ElasticsearchQueryViewer = ElasticsearchQueryViewer;