"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNotebook = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNotebook = id => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['fetchSearchNotebook', id],
    queryFn: () => http.get(`/internal/search_notebooks/notebooks/${id}`)
  });
};
exports.useNotebook = useNotebook;