"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotebookSchema = exports.NotebookCatalogSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotebookCatalogSchema = exports.NotebookCatalogSchema = _configSchema.schema.object({
  notebooks: _configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    title: _configSchema.schema.string(),
    description: _configSchema.schema.string(),
    url: _configSchema.schema.uri(),
    link: _configSchema.schema.maybe(_configSchema.schema.object({
      title: _configSchema.schema.string(),
      url: _configSchema.schema.uri()
    }))
  }, {
    unknowns: 'allow'
  }), {
    minSize: 1
  }),
  lists: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1
  })))
}, {
  unknowns: 'allow'
});
const NotebookCellSchema = _configSchema.schema.object({
  attachments: _configSchema.schema.maybe(_configSchema.schema.any()),
  auto_number: _configSchema.schema.maybe(_configSchema.schema.number()),
  cell_type: _configSchema.schema.maybe(_configSchema.schema.string()),
  execution_count: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  input: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  metadata: _configSchema.schema.maybe(_configSchema.schema.any()),
  outputs: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
  prompt_number: _configSchema.schema.maybe(_configSchema.schema.number()),
  source: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
}, {
  unknowns: 'allow'
});
const NotebookSchema = exports.NotebookSchema = _configSchema.schema.object({
  cells: _configSchema.schema.arrayOf(NotebookCellSchema, {
    minSize: 1
  }),
  metadata: _configSchema.schema.maybe(_configSchema.schema.any())
}, {
  unknowns: 'allow'
});