"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _i18n = require("@kbn/i18n");
var _searchApiKeysComponents = require("@kbn/search-api-keys-components");
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../hooks/use_kibana");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/api_key_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const API_KEY_MASK = '•'.repeat(60);
const ApiKeyFormContent = ({
  apiKey,
  status,
  toggleApiKeyVisibility,
  updateApiKey,
  manageKeysLink
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, apiKey ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchHomepage.connectToElasticsearch.apiKeysLabel",
    defaultMessage: "API key:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_searchSharedUi.FormInfoField, {
    value: status === _searchApiKeysComponents.Status.showPreviewKey ? apiKey : API_KEY_MASK,
    copyValue: apiKey,
    dataTestSubj: "searchHomepageApiKeyFormAPIKey",
    copyValueDataTestSubj: "searchHomepageAPIKeyButtonCopy",
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      iconType: status === _searchApiKeysComponents.Status.showPreviewKey ? 'eyeClosed' : 'eye',
      color: "text",
      display: "base",
      onClick: toggleApiKeyVisibility,
      "data-test-subj": "searchHomepageShowAPIKeyButton",
      "aria-label": _i18n.i18n.translate('xpack.searchHomepage.apiKeyForm.showApiKey', {
        defaultMessage: 'Show API key'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      display: "base",
      color: "text",
      iconType: "gear",
      href: manageKeysLink,
      target: "_blank",
      "aria-label": _i18n.i18n.translate('xpack.searchHomepage.apiKeyForm.manageApiKeys', {
        defaultMessage: 'Manage API keys'
      }),
      "data-test-subj": "manageApiKeysButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 17
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    size: "s",
    iconSide: "left",
    iconType: "key",
    onClick: () => setShowFlyout(true),
    "data-test-subj": "createApiKeyButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchHomepage.apiKeyForm.createButton",
    defaultMessage: "Create API key",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  })), showFlyout && /*#__PURE__*/_react.default.createElement(_searchApiKeysComponents.ApiKeyFlyoutWrapper, {
    onCancel: () => setShowFlyout(false),
    onSuccess: ({
      id,
      encoded
    }) => {
      updateApiKey({
        id,
        encoded
      });
      setShowFlyout(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  })));
};
const ApiKeysUserPrivilegesError = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s",
  justifyContent: "flexStart",
  responsive: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 117,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 118,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  "data-test-subj": "apiKeyFormNoUserPrivileges",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 119,
    columnNumber: 7
  }
}, _i18n.i18n.translate('xpack.searchHomepage.apiKeyForm.noUserPrivileges', {
  defaultMessage: 'Contact an administrator to manage API keys'
}))));
const ApiKeyForm = () => {
  var _share$url;
  const {
    apiKey,
    status,
    updateApiKey,
    toggleApiKeyVisibility
  } = (0, _searchApiKeysComponents.useSearchApiKey)();
  const {
    share
  } = (0, _use_kibana.useKibana)().services;
  const locator = share === null || share === void 0 ? void 0 : (_share$url = share.url) === null || _share$url === void 0 ? void 0 : _share$url.locators.get('MANAGEMENT_APP_LOCATOR');
  const manageKeysLink = locator === null || locator === void 0 ? void 0 : locator.useUrl({
    sectionId: 'security',
    appId: 'api_keys'
  });
  const queryClient = (0, _reactQuery.useQueryClient)();
  (0, _react.useEffect)(() => {
    queryClient.invalidateQueries([_constants.QueryKeys.ApiKey]);
  }, [apiKey, queryClient]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, status === _searchApiKeysComponents.Status.showUserPrivilegesError ? /*#__PURE__*/_react.default.createElement(ApiKeysUserPrivilegesError, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(ApiKeyFormContent, {
    apiKey: apiKey,
    status: status,
    updateApiKey: updateApiKey,
    toggleApiKeyVisibility: toggleApiKeyVisibility,
    manageKeysLink: manageKeysLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  })));
};
exports.ApiKeyForm = ApiKeyForm;