"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchConnectorIndexNames = fetchConnectorIndexNames;
var _fetch_connectors = require("./fetch_connectors");
var _identify_exceptions = require("../utils/identify_exceptions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function fetchConnectorIndexNames(client) {
  try {
    const allConnectors = await (0, _fetch_connectors.fetchConnectors)(client);
    return (allConnectors !== null && allConnectors !== void 0 ? allConnectors : []).map(connector => {
      var _connector$index_name;
      return (_connector$index_name = connector.index_name) !== null && _connector$index_name !== void 0 ? _connector$index_name : '';
    });
  } catch (error) {
    if ((0, _identify_exceptions.isIndexNotFoundException)(error)) {
      return [];
    }
    throw error;
  }
}