"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchClusterHasApiKeys = fetchClusterHasApiKeys;
exports.fetchUserStartPrivileges = fetchUserStartPrivileges;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchUserStartPrivileges(client, logger) {
  try {
    var _securityCheck$has_al;
    // relying on manage cluster privilege to check if user can create API keys
    // and can also have permissions for index monitoring
    const securityCheck = await client.security.hasPrivileges({
      cluster: ['manage'],
      index: [{
        names: ['*'],
        privileges: ['read', 'write']
      }]
    });
    return (_securityCheck$has_al = securityCheck.has_all_requested) !== null && _securityCheck$has_al !== void 0 ? _securityCheck$has_al : false;
  } catch (e) {
    logger.error(`Error checking user privileges for search API Keys`);
    logger.error(e);
    return false;
  }
}
async function fetchClusterHasApiKeys(client, logger) {
  try {
    const clusterApiKeys = await client.security.queryApiKeys({
      query: {
        term: {
          invalidated: false
        }
      }
    });
    return clusterApiKeys.api_keys.length > 0;
  } catch (e) {
    logger.error(`Error checking cluster for existing valid API keys`);
    logger.error(e);
    return true;
  }
}