"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchPublicPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _common = require("../common");
var _expressions = require("../common/expressions");
var _kibana_context = require("./expressions/kibana_context");
var _get_new_saved_search = require("../common/service/get_new_saved_search");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Saved search plugin public Setup contract
 */
// eslint-disable-next-line @typescript-eslint/no-empty-interface

/**
 * Saved search plugin public Start contract
 */

/**
 * Saved search plugin public Setup dependencies
 */

/**
 * Saved search plugin public Start dependencies
 */

class SavedSearchPublicPlugin {
  setup({
    getStartServices
  }, {
    contentManagement,
    expressions
  }) {
    contentManagement.registry.register({
      id: _common.SavedSearchType,
      version: {
        latest: _common.LATEST_VERSION
      },
      name: _i18n.i18n.translate('savedSearch.contentManagementType', {
        defaultMessage: 'Discover session'
      })
    });
    expressions.registerFunction((0, _kibana_context.getKibanaContext)({
      getStartServices
    }));
    expressions.registerType(_expressions.kibanaContext);
    return {};
  }
  start(_, {
    data: {
      search
    },
    spaces,
    savedObjectsTaggingOss,
    contentManagement: {
      client: contentManagement
    }
  }) {
    const deps = {
      search,
      spaces,
      savedObjectsTaggingOss,
      contentManagement
    };
    return {
      get: async (savedSearchId, serialized) => {
        const service = await getSavedSearchesService(deps);
        return service.get(savedSearchId, serialized);
      },
      getDiscoverSession: async discoverSessionId => {
        const service = await getSavedSearchesService(deps);
        return service.getDiscoverSession(discoverSessionId);
      },
      getAll: async () => {
        const service = await getSavedSearchesService(deps);
        return service.getAll();
      },
      getNew: () => {
        return (0, _get_new_saved_search.getNewSavedSearch)({
          searchSource: search.searchSource
        });
      },
      save: async (savedSearch, options) => {
        const service = await getSavedSearchesService(deps);
        return service.save(savedSearch, options);
      },
      saveDiscoverSession: async (discoverSession, options) => {
        const service = await getSavedSearchesService(deps);
        return service.saveDiscoverSession(discoverSession, options);
      },
      checkForDuplicateTitle: async props => {
        const service = await getSavedSearchesService(deps);
        return service.checkForDuplicateTitle(props);
      },
      byValueToSavedSearch: async (result, serialized) => {
        const service = await getSavedSearchesService(deps);
        return service.byValueToSavedSearch(result, serialized);
      }
    };
  }
}
exports.SavedSearchPublicPlugin = SavedSearchPublicPlugin;
const getSavedSearchesService = (0, _lodash.once)(async deps => {
  const {
    SavedSearchesService
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./service/saved_searches_service')));
  return new SavedSearchesService(deps);
});